/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QGroupBox>
#include <QTextEdit>
#include <qevent.h>

#include "CommonDefinitions.h"
#include "DesEditorOutputUiPart.h"


namespace DESpot
{


DesEditorOutputUiPart::DesEditorOutputUiPart(Ui::DesEditorUI* pUiContainer)
{
	if (pUiContainer == null)
		throw EX("Invalid (null) UI Container. Cannot create the DES editor output UI part")

	//setup widget references
	m_pDesEditorOutputGBox = pUiContainer->m_desEditorOutputGBox;
	m_pDesEditorOutputWidg = pUiContainer->m_outputWidg;

	//setup event filters
	m_pDesEditorOutputGBox->installEventFilter(this);

	//initialize widgets
}

//_________________________________________________________________________________________________

DesEditorOutputUiPart::~DesEditorOutputUiPart(void)
{
}

//_________________________________________________________________________________________________

bool DesEditorOutputUiPart::eventFilter(QObject* target, QEvent* event)
{	
	if (target == m_pDesEditorOutputGBox && event->type() == QEvent::Resize)
	{
		QResizeEvent* resizeEvent = dynamic_cast<QResizeEvent*>(event);
		m_pDesEditorOutputWidg->resize(resizeEvent->size() - QSize(0,28));
	}

	return QObject::eventFilter(target, event);

}

//_________________________________________________________________________________________________

void DesEditorOutputUiPart::clear()
{
	m_pDesEditorOutputWidg->clear();
}

//_________________________________________________________________________________________________

void DesEditorOutputUiPart::write(const QString& text)
{
	m_pDesEditorOutputWidg->insertHtml(text);
	m_pDesEditorOutputWidg->moveCursor(QTextCursor::End);
}

//_________________________________________________________________________________________________

void DesEditorOutputUiPart::writeLine(const QString& text)
{
	m_pDesEditorOutputWidg->insertHtml(text);
	m_pDesEditorOutputWidg->insertHtml("<br>");
	m_pDesEditorOutputWidg->moveCursor(QTextCursor::End);
}

} //end of namespace DESpot

