/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QString>

class QMainWindow;

namespace DESpot
{

class MainForm;

class DespotForm
{
	public:
		enum FormType
		{
			eMainForm,
			eDesEditor,
			eFlatProjectEditor,
			eHierProjectEditor,
			eProjectEventPool,
			//Add by XMA, May/8/08 For simulation
			eSimConfig,
			// Add by XMA, May/8/08 for Grahpic des editor
			eGedDesEditor
		};
	
	public:
		DespotForm(MainForm* pMainForm);
		DespotForm(MainForm* pMainForm, QMainWindow* thisWnd, DespotForm* ownerForm, FormType formType);
		virtual ~DespotForm(void);

	//Operations________________________________________________	
	public:
		void open();

		QMainWindow* window();

		DespotForm* owner();

		MainForm* mainForm();

		FormType  type();

		QString   title();

		virtual QString getDocName() { return QString();}
		virtual QString getDocFileName() { return QString();}		
		bool openedFromFile();

		bool onCloseForm();

	protected:
		//the window the corresponds to this form
		QMainWindow* m_thisWnd; 

		//the owner of this form. MainForm has a null owner
		DespotForm*  m_owner; 

		//the top-most form in DESpot. All other forms have access to it
		MainForm* m_pMainForm; 
		
		FormType  m_formType;
};

} //end of namespace DESpot
