/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <string>
#include <qthread.h>
#include "DesAlgo.h"
#include "DesHierProject.h"

namespace DESpot
{
	class HighSubsysNonBlockAlgo;
	class LowSubsysNonBlockAlgo;

	class LwNonBlockingAlgo : public DesAlgo, public QThread  
	{
		public:
			LwNonBlockingAlgo(DesHierProject& project, bool runIncremental = true);
			virtual ~LwNonBlockingAlgo(void);

		public:
			virtual bool runAlgo();

			bool isLwNonBlocking() const;

			void overrideLwNonBlocking(bool lwNonBlock);

		protected:
			virtual void prepareRun();

			void clearAlgo();


		protected:			
			DesHierProject& m_project;

			HighSubsysNonBlockAlgo* m_hNonBlockAlgo;
			
			std::vector<LowSubsysNonBlockAlgo*> m_lNonBLockAlgoList;

			bool m_isLwNonBlock;

		private:
			static const std::wstring cLwNonBlockAlgoDesc;
		    static const std::wstring cIntegrityNotConfirmed;
			static const std::wstring cProjectInvalid;
		public:
            virtual void run();
			bool verifyProjectIntegrity();
	};
}
