/*
 * GedDesHelper.h
 *
 *  Created on: Jun 1, 2009
 *      Author: alex
 */

#ifndef GEDDESHELPER_H_
#define GEDDESHELPER_H_

#include <QList>
#include <QPointF>
#include "Des.h"
#include "GedDesTrans.h"

namespace DESpot
{

class GedDesHelper
{
public: // Fields
	static const QPointF NOTEXIST;

public: // Methods
	GedDesHelper(Des* pDes) :
		m_pDes(pDes), m_pStateMap(&m_pDes->getGedInfo())
	{
	}
	virtual ~GedDesHelper()
	{
	}

	GedDesState* insertState(const DesState *state, QPointF pos,
			QPointF labelPos = QPointF(20, 20));
	GedDesTrans* insertTrans(const DesTransition *trans, bool& isNew);
	GedDesTrans* insertTrans(const DesTransition *trans, QList<QPointF> pos,
			QPointF labelPos, bool& isNew);
	GedDesTrans* insertTrans(const DesTransition *trans, qreal angle,
			QPointF labelPos, bool& isNew);

	const GedDesState* gedState(const DesState *state) const;
	QPointF statePos(const DesState &state);
	QPointF stateLabelPos(const DesState &state);
	QList<QPointF> transPos(const DesTransition &trans);
	QPointF transLabelPos(const DesTransition &trans);
	qreal selfloopPos(const DesTransition &trans);

	GedDesTrans* gedTrans(GedDesState *startState, GedDesState *endState);
	GedDesTrans* gedTrans(GedDesState *startState, const DesEvent* ev, GedDesState *endState);

	// Is useEvent is true method will use event to find corresponding transition
	// otherwise only states are used.
	GedDesTrans* gedTrans(const DesTransition *desTrans, bool useEvent=true);

private: // Methods
	GedDesTrans* insertTransInternal(const DesTransition *desTrans, bool& isNew);

private: // Fields
	Des* m_pDes;
	Des::GedInfo* m_pStateMap;
};

}

#endif /* GEDDESHELPER_H_ */
