/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QMainWindow>
#include <QCloseEvent>

#include "DespotForm.h"

class QTabWidget;

namespace DESpot
{
	class MainForm;
	class EventPoolForm;
	class ProjectWorkspace;
	class DesProject;
	class Des;
	class CtrlStdAlgo;
    class MultiCtrlAlgo;
	class OutputUiPart;
	class ProjIntegrityAlgo;
	class UpdateProgressInterface;

	class ProjectEditor:	public QMainWindow, public DespotForm
	{
		Q_OBJECT

		public:
			ProjectEditor(MainForm* pMainForm, FormType formType);
			ProjectEditor(DesProject* project, MainForm* pMainForm, FormType formType);
			virtual ~ProjectEditor(void);
		
		public:
			DesProject* project();

		public:
			virtual QString getDocName();
			virtual QString getDocFileName(); 

		//Menu/Toolbar Handlers_______________________________
		protected slots:
			virtual void onSaveProject();
			virtual void onSaveProjectAs();
			virtual void onDisplayEventPool();
			virtual void onProjectSetName();
			virtual void onPrintProject();
			virtual void onCloseProject();

			virtual void onAddDes();
			virtual void onEditDes();
			virtual void onRemoveDes();

			void onCheckProjectIntegrity(ProjIntegrityAlgo& integAlgo);
			virtual void onCheckProjectIntegrity();
			virtual void onCleanProject();
			virtual void onCheckProject();
			virtual void onRunMeetTool();
			virtual void onRunMultiCtrlTool();
			virtual void onRunSyncProductTool();	
			virtual void onRunNonBlockingTool();
			virtual void onRunCtrlTool();
			virtual void onRunSynthesisTool();
			virtual void onRunSimTool();

			//#ifdef __ENABLE_BDD__
				//Removed By Adam. no longer used in flat only hisc (moved to HierProjectEditor.h)
				virtual void onRunBddMeetTool();
				//virtual void onRunBddMultiCtrlTool();
				virtual void onRunBddSyncProductTool();	
				//virtual void onRunBddNonBlockingTool();
				virtual void onRunBddSynthesisTool();
			//#endif

			virtual void onChangedCurrentDes(Des* pCrtDes, Des* pOldCrtDes);

		protected:
			virtual bool eventFilter(QObject* target, QEvent* event);						
			virtual void closeEvent(QCloseEvent *event);

		//Implementation methods_____________________________
		protected:
			void setupConnections();
			void updateWindowTitle();
			bool saveProjectDes();
			bool attemptSaveProject();
			bool attemptSaveProjectAs();

			OutputUiPart& output();

			UpdateProgressInterface* progressInterface();

		//Implementation data________________________________
		protected:
			DesProject* m_pProject;
			ProjectWorkspace* m_pWorkspace;
			EventPoolForm* m_pEventPoolForm;

			//The current component in the project
			Des* m_pCrtDes;
	};

} //end of namespace DESpot
