/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QObject>
#include "ui_DesEditor.h"
#include "DesNotifications.h"

class QGroupBox;
class QTreeWidget;

namespace DESpot
{
	class Des;
	class DesState;

	class StateQuickLookUiPart: public QObject, private DesNotifications
	{
		Q_OBJECT	

		public:
			StateQuickLookUiPart(Ui::DesEditorUI* pUiContainer, Des* pDes);
			virtual ~StateQuickLookUiPart(void);

		public:
			void showQuickLookFor(const DesState& state);

		//Overridables__________________________________
		protected:
			virtual bool eventFilter(QObject* target, QEvent* event);

		//Slots_________________________________________
		private slots:
			void resizeQuickLookHeaders(int quickLookWidgWidth);
			void onChangedCurrentState(const DesState* pNewCurrentState, const DesState* pOldCurrentState);
			void onCurrentStateChanged(const DesState& crtState);

		//DES notifications
		private:
			virtual void onEventChanged(const DesEvent& changedEvent);			
			virtual void onTransitionRemoved(const DesTransition& removedTrans);
			virtual void onSelfTransitionRemoved(const DesEvent& selfTransEvent);


		//Implementation Methods________________________
		private:
			void initStateQuickLookWidget();
			void updateStateQuickLookWidget();
			void clearStateQuickLookWidget();

			const DesTransition& getTransFromUiItem(QTreeWidgetItem& transUiItem);
			void addTransToUiItem(QTreeWidgetItem& transUiItem, const DesTransition& trans);
			void delTransFromUiItem(QTreeWidgetItem& transUiItem);
			void findAndRemoveUiItem(const DesTransition& trans);

		private:
			QGroupBox*		  m_pStateQuickLookGroupBox;
			DespotTreeWidget* m_pStateQuickLookWidg;

			//Widget items in the quick look tree widget
			QTreeWidgetItem* m_stateRootItem;
			QTreeWidgetItem* m_enterEventsItem;
			QTreeWidgetItem* m_loopEventsItem; 
			QTreeWidgetItem* m_exitEventsItem; 

			const DesState* m_pCrtState;

			//The Des that owns the event displayed in this UI part
			Des* m_pDes;
			unsigned int m_desListnerId;
	};

} //end of namespace DESpot
