/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QString>
#include "DesDataTableWidget.h"
#include "DesEvent.h"


namespace DESpot
{
	class Des;

	class DesEventSetTableWidget : public DesDataTableWidget
	{
		public:
			DesEventSetTableWidget(QWidget* parent = null);
			~DesEventSetTableWidget(void);

		public:
			virtual void loadData(Des* des, bool highLevelDes = false);
		
		private:
			QString getEventTypeDesc(const DesEvent& event, bool highLevelDes = false);
			
		public:
			static const QString cHighEventDesc;
			static const QString cLowEventDesc;
			static const QString cReqEventDesc;
			static const QString cAnsEventDesc;
			static const QString cLdEventDesc;
			
			static const QString cCtrlEventDesc;
			static const QString cUnctrlEventDesc;

			static const QString cEventDesc;
	};
} //end of namespace DESpot
