/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <map>
#include "CommonDefinitions.h"
#include "TransitionMapIterator.h"


namespace DESpot
{
	class DesStateTransMapIterator : public TransitionMapIterator
	{
		public:

			DesStateTransMapIterator(const DesState& state,
								  const std::map<const DesState*, 
				                                 std::map<const DesEvent*, 
														  std::map<const DesState::ID, const DesState*>*
														 >*
											    >& transMap
												)
				: TransitionMapIterator(transMap),
 				  m_state(&state)
			{
			}
			
			virtual ~DesStateTransMapIterator(void)
			{
			}

		//Public operations
		public:
			void setState(const DesState& state)
			{
				m_state = &state;
				
				//regardless where the iterator is move it to the first element now that the state
				//has been reset
				first();
			}

		//Overridables
		protected:
			virtual TransMapIt getStartState()   const
			{
				//This iterator starts and ends with with m_state
				return m_transMap.find(m_state);
			}

			virtual TransMapIt getNextFromState() const
			{
				//This iterator is only interested in m_state only so no next state
				return m_transMap.end();
			}

		protected:
			//disallow copying
			DesStateTransMapIterator(const DesStateTransMapIterator& other): TransitionMapIterator(other), m_state(other.m_state) {}
			DesStateTransMapIterator& operator= (const DesStateTransMapIterator&) { return *this;}

		protected:
			//This iterator goes through all the transitions leaving from this state including or not
			//global self transitions
			const DesState* m_state;
	};

} //end of namespace Despot

