#ifndef SIMDEBUG_H
#define SIMDEBUG_H

#include<cassert>

namespace DESpot
{
// The pre-defined debugging flags are:
typedef unsigned short us;
#define  DBGDES  0x01
#define  DBGSIM  0x02
#define  DBGAll  0x03  //DBGDES|DBGSIM

class Debug {
  public:
    Debug(us flagList);
    bool IsEnabled(us flag);

  private:
    us enableFlags;          /* controls which DEBUG messages are printed*/
};

extern Debug *debug;

#define DEBUG(flag,expr)                      \
    if (!debug->IsEnabled(flag)) {} else {    \
        cerr << expr << endl;                 \
    }

}
#endif
