/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QMessageBox>
#include <QButtonGroup>

#include "DesEventEditorDlg.h"

namespace DESpot
{

const QString DesEventEditorDlg::cDefaultTypeName = "Default";
const QString DesEventEditorDlg::cRequestTypeName = "Request";
const QString DesEventEditorDlg::cAnswerTypeName = "Answer";
const QString DesEventEditorDlg::cLDataTypeName = "Low Data";


DesEventEditorDlg::DesEventEditorDlg(DesType desType, QWidget *parent) : QDialog(parent)
{
	setupUi(this);
	setupEventTypeWidget(desType);
}

//_________________________________________________________________________________________________

DesEventEditorDlg::DesEventEditorDlg(DesType desType, const DesEvent& event, QWidget *parent) : QDialog(parent)
{
	setupUi(this);

	m_event = event;
	
	setupEventTypeWidget(desType);
	
	updateUI();
}

//_________________________________________________________________________________________________

DesEventEditorDlg::~DesEventEditorDlg(void)
{
}

//_________________________________________________________________________________________________

const DesEvent& DesEventEditorDlg::resultEvent() const
{
	return m_event;
}

//_________________________________________________________________________________________________

void DesEventEditorDlg::setupEventTypeWidget(DesType desType)
{
	if (desType != eInterfaceDes)
	{
		m_eventTypeWidg->addItem(cDefaultTypeName, eDefaultEvent);
	}

	m_eventTypeWidg->addItem(cAnswerTypeName, eAnswerEvent);
	m_eventTypeWidg->addItem(cRequestTypeName, eRequestEvent);
	m_eventTypeWidg->addItem(cLDataTypeName, eLDataEvent);
	
	m_eventTypeWidg->setCurrentIndex((desType == eInterfaceDes) ? 1 : 0);
}

//_________________________________________________________________________________________________
//Updates the dialog control with the values in the m_event
void DesEventEditorDlg::updateUI()
{
	m_eventNameEdit->setText(QString::fromStdWString(m_event.getName()));
	m_eventAliasEdit->setText(QString::fromStdWString(m_event.getAlias()));
	m_eventCtrlWidg->setChecked(m_event.isControllable());
	m_eventTypeWidg->setCurrentIndex(m_eventTypeWidg->findData(m_event.getSimpleType()));
}

//_________________________________________________________________________________________________

void DesEventEditorDlg::accept()
{
	//set the name of the event
	if (m_eventNameEdit->text().size() > 0)
	{
		try
		{
			m_event.setName(m_eventNameEdit->text().toStdWString());
		}
		catch(EXO)
		{
			display_ex();
			
			return; //do not go any further until the user has provided a proper name for the event
		}
	}
	else
	{
		QMessageBox::critical(this, STR_DESPOT_ERROR, STR_EVENT_NAME_MANDATORY_EX);
		
		return; //do not go any further until the user has provided a name for the event
	}

	//set the alias of the event
	if (m_eventAliasEdit->text().size() > 0)
	{
		try
		{
			//An alias was provided so set it
			m_event.setAlias(m_eventAliasEdit->text().toStdWString());
		}
		catch(EXO)
		{
			display_ex();
			
			return; //do not go any further until the user has provided a proper name for the event
		}
	}
	else
	{
		m_event.setAlias(L"");
	}
	
	//set the controllability and the type
	m_event.setControllable(m_eventCtrlWidg->isChecked());
	m_event.setType((EventType)m_eventTypeWidg->itemData(m_eventTypeWidg->currentIndex()).toInt());
	
	//close the dialog
	QDialog::accept();
}			

//_________________________________________________________________________________________________

void DesEventEditorDlg::reject()
{
	//close the dialog
	QDialog::reject();
}

} //end of namespace DESpot 
