/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <string>
#include <qthread.h>
#include "DesAlgo.h"
#include "DesHierProject.h"


namespace DESpot
{
	class LowSubsysIConsistAlgo;

	class IConsistAlgo : public DesAlgo,public QThread 
	{
		public:
			IConsistAlgo(DesHierProject& project, bool runIncremental = true);
			virtual ~IConsistAlgo(void);

		public:
			virtual bool runAlgo();

			bool isInterfaceConsistent() const;

			void overrideInterfConsist(bool iConsist);

		protected:
			virtual void prepareRun();

			//Step1: verify the project's integrity. This among other things checks that the event set
			//is partioned correctly which takes care of Point 1 of the I-consist definition
			virtual bool verifyProjectIntegrity();

			//Step2: verify that all interfaces are LD-consistent
			virtual bool verifyLdInterfaces();

			//Step3: verify that all answers enabled by interfaces are accepted by the high-level subsystem
			virtual bool verifyHighLevelSubsysIConsist();

			//Step4: verify that all requests enabled by interfaces are accepted by their respective low-levels
			//Step 5 & 6: verify that each low-level subsystem implements its interface properly
			virtual bool verifyLowLevelSubsysIConsist();

		protected:
			void destroyLowSubsysAlgos();


		protected:
			DesHierProject& m_project;

			bool m_isInterfConsist;

			//the map of i-consist algorithms of each low-level subsystem
			typedef std::map<std::wstring, LowSubsysIConsistAlgo*> LowSubsysAlgoMap;
			typedef LowSubsysAlgoMap::iterator LowSubsysAlgoIt;
			LowSubsysAlgoMap m_lowSubsysAlgoMap;

		private:
			static const std::wstring cIConsistAlgoDesc;
			static const std::wstring cIntegrityNotConfirmed;
			static const std::wstring cProjectInvalid;
			static const std::wstring cIntefNotLd;
		public:
            virtual void run();

	};
}
