/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "FlatProjSummaryUiPart.h"
#include "DesFlatProject.h"

namespace DESpot
{

FlatProjSummaryUiPart::FlatProjSummaryUiPart(Ui::FlatProjectEditorUI* pUiContainer, DesFlatProject* pProject):
	ProjSummaryUiPart(pUiContainer, pProject)
{
	initWidgets(pUiContainer);

	updateUi();
}

//_________________________________________________________________________________________________

FlatProjSummaryUiPart::~FlatProjSummaryUiPart(void)
{
}

//_________________________________________________________________________________________________
void FlatProjSummaryUiPart::initWidgets(Ui::FlatProjectEditorUI* pUiContainer)
{
	//initialize and group non-blocking summary widgets
	m_nonBlockNotChkLabel = pUiContainer->m_nonBlockNotChkLabel;
	m_smryNonBlockYesWidg = pUiContainer->m_smryNonBlockYesWidg;
	m_smryNonBlockNoWidg = pUiContainer->m_smryNonBlockNoWidg;	
	
	m_nonbBlockRadioBtnGroup = new OutputButtonGroup(this);
	m_nonbBlockRadioBtnGroup->addButton(m_smryNonBlockYesWidg);
	m_nonbBlockRadioBtnGroup->addButton(m_smryNonBlockNoWidg);

	//initialize the non-blocking date stamp
	m_smryNonBlockVerifiedLabel = pUiContainer->m_smryNonBlockVerifiedLabel;
	m_smryNonBlockDateStampWidg = pUiContainer->m_smryNonBlockDateStampWidg;

	//initialize and group controllability summary widgets
	m_ctrlNotChkLabel = pUiContainer->m_ctrlNotChkLabel;
	m_smryCtrlYesWidg = pUiContainer->m_smryCtrlYesWidg;
	m_smryCtrlNoWidg = pUiContainer->m_smryCtrlNoWidg;
	
	m_ctrlRadioBtnGroup = new OutputButtonGroup(this);
	m_ctrlRadioBtnGroup->addButton(m_smryCtrlYesWidg);
	m_ctrlRadioBtnGroup->addButton(m_smryCtrlNoWidg);

	//initialize controllability stamp
	m_smryCtrlVerifiedLabel = pUiContainer->m_smryCtrlVerifiedLabel;
	m_smryCtrlDateStampWidg = pUiContainer->m_smryCtrlDateStampWidg;

	m_nonblockSpacer1 = pUiContainer->m_nonblockSpacer1;
	m_nonblockSpacer2 = pUiContainer->m_nonblockSpacer2;
	m_nonblockSpacer3 = pUiContainer->m_nonblockSpacer3;
	m_nonblockSpacer4 = pUiContainer->m_nonblockSpacer4;

	m_ctrlSpacer1 = pUiContainer->m_ctrlSpacer1;
	m_ctrlSpacer2 = pUiContainer->m_ctrlSpacer2;
	m_ctrlSpacer3 = pUiContainer->m_ctrlSpacer3;
	m_ctrlSpacer4 = pUiContainer->m_ctrlSpacer4;

}

//_________________________________________________________________________________________________

DesFlatProject* FlatProjSummaryUiPart::project()
{
	return dynamic_cast<DesFlatProject*>(m_pProject);
}

//_________________________________________________________________________________________________

void FlatProjSummaryUiPart::updateUi()
{
	ProjSummaryUiPart::updateUi();

	updateNonBlockUi();
	updateCtrlUi();
}

//_________________________________________________________________________________________________

void FlatProjSummaryUiPart::updateNonBlockUi()
{
	NonBlockingProp nonBlockProp = m_pProject->getNonBlockingProp();

	//either show the "not verified" label or show the non-blocking status widgets depending
	//whether the non-blocking property has been verified or not
	bool showNonBlockProp = (nonBlockProp != eNonBlockNotVerified);
	m_nonBlockNotChkLabel->setVisible(!showNonBlockProp);	
	
	//show (or hide) and update the status of the verification widgets
	m_smryNonBlockYesWidg->setVisible(showNonBlockProp);
	m_smryNonBlockNoWidg->setVisible(showNonBlockProp);
	m_nonblockSpacer1->setVisible(showNonBlockProp);
	m_nonblockSpacer2->setVisible(showNonBlockProp);
	m_nonblockSpacer3->setVisible(showNonBlockProp);
	m_nonblockSpacer4->setVisible(showNonBlockProp);
	m_smryNonBlockVerifiedLabel->setVisible(showNonBlockProp);
	m_smryNonBlockDateStampWidg->setVisible(showNonBlockProp);

	if (nonBlockProp == eNonBlockYes)
	{
		m_nonbBlockRadioBtnGroup->check(m_smryNonBlockYesWidg);
	}
	else
	{
		m_nonbBlockRadioBtnGroup->check(m_smryNonBlockNoWidg);
	}
	
	//show / hide and update the date of verification
	if (showNonBlockProp)
	{
		QString     nonBlockStamp = QString::fromStdWString(project()->getNonBlockingStamp());
		QDateTime   nonBlockDateTime = QDateTime::fromString(nonBlockStamp);
		m_smryNonBlockDateStampWidg->setDateTime(nonBlockDateTime);
	}

	m_gridLayout->invalidate();
}

//_________________________________________________________________________________________________

void FlatProjSummaryUiPart::updateCtrlUi()
{
	ControllableProp ctrlProp = m_pProject->getControllableProp();

	//either show the "not verified" label or show the non-blocking status widgets depending
	//whether the non-blocking property has been verified or not
	bool bShowCtrlProp = (ctrlProp != eCtrlNotVerified);
	m_ctrlNotChkLabel->setVisible(!bShowCtrlProp);	
	
	//show (or hide) and update the status of the verification widgets
	m_smryCtrlYesWidg->setVisible(bShowCtrlProp);
	m_smryCtrlNoWidg->setVisible(bShowCtrlProp);
	m_ctrlSpacer1->setVisible(bShowCtrlProp);
	m_ctrlSpacer2->setVisible(bShowCtrlProp);
	m_ctrlSpacer3->setVisible(bShowCtrlProp);
	m_ctrlSpacer4->setVisible(bShowCtrlProp);
	m_smryCtrlVerifiedLabel->setVisible(bShowCtrlProp);
	m_smryCtrlDateStampWidg->setVisible(bShowCtrlProp);

	if (ctrlProp == eCtrlYes)
	{
		m_ctrlRadioBtnGroup->check(m_smryCtrlYesWidg);
	}
	else
	{
		m_ctrlRadioBtnGroup->check(m_smryCtrlNoWidg);
	}
	
	//update the date of verification
	if (bShowCtrlProp)
	{
		QString     ctrlStamp = QString::fromStdWString(project()->getCtrlStamp());
		QDateTime   ctrlDateTime = QDateTime::fromString(ctrlStamp);
		m_smryCtrlDateStampWidg->setDateTime(ctrlDateTime);
	}

	m_gridLayout->invalidate();
}

//_________________________________________________________________________________________________

void FlatProjSummaryUiPart::onCtrlStatusChanged()
{
	updateCtrlUi();
}

//_________________________________________________________________________________________________

void FlatProjSummaryUiPart::onNonBlockStatusChanged()
{
	updateNonBlockUi();
}

} //end of namespace DESpot
