/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QMessageBox>
#include "AddLowLevelSubsysDlg.h"
#include "InterfaceIterator.h"
#include "DesSubsystem.h"

namespace DESpot
{

AddLowLevelSubsysDlg::AddLowLevelSubsysDlg(const DesHierProject& project, QWidget* parent /*= null*/):
		QDialog(parent), m_project(project), m_newInterface(false)
{
	setupUi(this);
	m_subsysNameWidg->setFocus();
	setupInterfWidget();
}

//_________________________________________________________________________________________________

AddLowLevelSubsysDlg::~AddLowLevelSubsysDlg(void)
{
}

//_________________________________________________________________________________________________

std::wstring AddLowLevelSubsysDlg::getSubsysName() const
{
	return m_subsysName;
}

//_________________________________________________________________________________________________

std::wstring AddLowLevelSubsysDlg::getInterfName() const
{
	return m_interfName;
}

//_________________________________________________________________________________________________

void AddLowLevelSubsysDlg::setInterfName(const std::wstring& interfName)
{
	m_interfName = interfName;
}

//_________________________________________________________________________________________________

bool AddLowLevelSubsysDlg::isNewInterface() const
{
	return m_newInterface;
}

//_________________________________________________________________________________________________

void AddLowLevelSubsysDlg::setupInterfWidget()
{
	DesHierProject::InterfIteratorPtr interfIt = m_project.createInterfIterator();
	for(interfIt->first(); interfIt->isDone() == false; interfIt->next())
	{
		const DesInterface& interf = interfIt->currentItem();
		if (m_project.getRootSubsys().isDependentOn(interf) == false)
		{
			m_interfWidg->addItem(QString::fromStdWString(interf.getName()));
		}
	}

	if (m_interfName.empty() == false)
	{
		int idx = m_interfWidg->findText(QString::fromStdWString(m_interfName));
		m_interfWidg->setCurrentIndex(idx);
	}
}

//_________________________________________________________________________________________________

void AddLowLevelSubsysDlg::accept()
{
	m_subsysName = m_subsysNameWidg->text().toStdWString();
	if (m_subsysName.empty())
	{
		QMessageBox::critical(this, STR_DESPOT_ERROR, STR_SUBSYS_NAME_EMPTY);
		return;
	}

	if (m_project.findName(m_subsysName))
	{
		QMessageBox::critical(this, STR_DESPOT_ERROR, STR_PROJ_NAME_ALREADY_EXISTS);
		return;
	}

	m_interfName = m_interfWidg->currentText().toStdWString();
	if (m_interfName.empty())
	{
		QMessageBox::critical(this, STR_DESPOT_ERROR, STR_INTERF_NAME_EMPTY);
		return;
	}
	else
	{
		//check to see if it is a valid name
		ProjectCompType projCompType;
		if (m_project.findName(m_interfName, projCompType))
		{
			if (projCompType == eInterfaceComp)
			{
				//Ensure there is no dependency on this interface already
				const DesInterface& interf = m_project.getInterface(m_interfName);
				if (m_project.getRootSubsys().isDependentOn(interf))
				{
					QMessageBox::critical(this, STR_DESPOT_ERROR, STR_INTERF_ALREADY_DEPENDENT);
					return;
				}
				else
				{
					m_newInterface = false;
				}
			}
			else
			{
				//the name is used by a different type of component
				QMessageBox::critical(this, STR_DESPOT_ERROR, STR_INTERF_NAME_ALREADY_USED_IN_PROJECT);
				return;
			}
		}
		else
		{
			m_newInterface = true;
		}
	}

	QDialog::accept();
}

//_________________________________________________________________________________________________

void AddLowLevelSubsysDlg::reject()
{
	QDialog::reject();
}

} //end of namespace DESpot
