/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ui_FlatProjectEditor.h"
#include "ui_HierProjectEditor.h"
#include "DesProject.h"
#include "DesNotifications.h"
#include "DesEvent.h"
#include "DesStateSetTableWidget.h"
#include "DesEventSetTableWidget.h"
#include "DesTransSetTableWidget.h"

class QLabel;
class QTableWidget;


namespace DESpot
{
	class ProjectEditor;
	class DesProject;

	class DesViewUiPart: public QObject, private DesNotifications
	{
		Q_OBJECT

		public:
			//The Des View UI Part is used for both flat and hierarchial projects
			DesViewUiPart(Ui::FlatProjectEditorUI* pUiContainer, DesProject* pProject);
			DesViewUiPart(Ui::HierProjectEditorUI* pUiContainer, DesProject* pProject);
			virtual ~DesViewUiPart(void);

		private:			
			//Initializes the widgets from either the flat project editor or the hierhical project editor
			//Called from the two constructors
			template<class T> 
			void initWidgets(T* pUiContainer);
			void updateUi();			
			void updateHeaderUi();
			void updateStatesUi();
			void updateEventsUi();
			void updateTransitionsUi();

			QString getDesType();
			QString getDesStatus();

		//Des Notifications	
		private:
			virtual void onNameChanged(const std::wstring& /*oldName*/, const std::wstring& /*newName*/) {updateHeaderUi();}
			virtual void onFileNameChanged(const std::wstring& /*oldFileName*/, const std::wstring& /*newFileName*/) {updateHeaderUi();}
			virtual void onTypeChanged(DesType /*oldType*/, DesType& /*newType*/) {updateHeaderUi();}
			virtual void onIntegrityChanged() {updateHeaderUi();}
			virtual void onReachabilityChanged() {m_stateTableWidg->loadData(m_des, m_isHighLevelDes); }
			
			virtual void onStateAdded(const DesState& /*addedState*/) { updateStatesUi(); }
			virtual void onStateChanged(const DesState& /*changedState*/) { updateStatesUi(); }
			virtual void onStateRemoved(const DesState::ID& /*stateId*/) { updateStatesUi(); }

			virtual void onEventAdded(const DesEvent& /*addedEvent*/) { updateEventsUi(); }
			virtual void onEventChanged(const DesEvent& /*changedEvent*/){ updateEventsUi(); }
			virtual void onEventRemoved(const DesEvent::ID& /*eventId*/){ updateEventsUi(); }

			virtual void onTransitionAdded(const DesTransition& /*addedTrans*/) { updateTransitionsUi();  }
			virtual void onGlobalSelfTransitionAdded(const DesEvent& /*selfTransEvent*/) { updateTransitionsUi();  }
			virtual void onTransitionChanged(const DesTransition& /*trans*/, const DesTransition& /*change*/) { updateTransitionsUi();  }
			virtual void onTransitionRemoved(const DesTransition& /*removedTrans*/) { updateTransitionsUi();  }
			virtual void onSelfTransitionRemoved(const DesEvent& /*selfTransEvent*/) { updateTransitionsUi();  }


		private slots:
			void onChangedCurrentDes(Des* pNewCrtDes, Des* pOldCrtDes);
			void onChangedCurrentSubsys(const DesSubsystem* pNewCrtSubsys, const DesSubsystem* pOldCrtSubsys);
			void onChangedCurrentInterf(const DesInterface* pNewCrtInterf, const DesInterface* pOldCrtInterf);

		private:
			//The project that owns the DES displayed in this UI Part
			DesProject*   m_project;
			
			//The des being displayed in the UI part
			Des* m_des;
			bool m_isHighLevelDes;
			
			//The event types displayed in the event section. If -1 no event type is displayed and the count
			//widget must be hidden. If not -1 the array stores EventType values
			EventType m_eventTypes[4];
			QString m_eventTypeDesc[4];
			static const int cEventTypeCount;
			static const EventType cEventTypeNone;
			
			unsigned int m_desListnerId;

			//Des Information Widgets
			QLabel* m_desNameDisplay;
			QLabel* m_desTypeDisplay;
			QLabel* m_desStatusDisplay;
			QLabel* m_desLocDisplay;
			
			//Des state widgets
			QLabel* m_initStateDisplay;
			QLabel* m_stateCountDisplay;
			QLabel* m_markedStateCountDisplay;
			DesStateSetTableWidget* m_stateTableWidg;
			
			//Des event widgets
			QLabel* m_eventCountDisplay;
			QLabel* m_ctrlEventCountDisplay;
			QLabel* m_eventTypeCountDisplay[4];
			DesEventSetTableWidget* m_eventTableWidg;

			//Des transition widgets
			QLabel* m_transCountDisplay;
			QLabel* m_selfTransCountDisplay;
			DesTransSetTableWidget* m_transTableWidg;

		private:
			static const int cStateTableColCount;
			static const int cEventTableColCount;
			static const int cTransTableColCount;

			static const QString cDesTypeRegular;
			static const QString cDesTypeSubsystem;
			static const QString cDesTypeInterface;

			static const QString cDesIntegStatusYes;
			static const QString cDesIntegStatusNo;
			static const QString cDesIntegStatusNotVerified;

			static const QString cTransDesc;
			static const QString cSelfTransDesc;
	};
	
} //end of namespace DESpot

