/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <assert.h>
#include <QSize>
#include <string>
#include <QtXml/QXmlParseException>

//Define the symbol belo if the project is being built with the MinGW compiler on Windows. Disable this definition if
//the compiler is theVisual C++ or the  Linux/Unix gcc compiler as they are most up-to-date compilers
//#define MINGW_GCC

#ifdef _DEBUG
	#define _DEBUG_DESPOT
#endif

// define symbol below if compiling against qt 4.6 or higher
 #if QT_VERSION >= 0x040600
    #define __QT_Vers_gteq_4_6__
 #endif


#define __ENABLE_BDD__

//Defines_______________________________________

const int null = 0;

//Exception macros
#define EX(text) std::wstring(L##text);

#define EXO const std::wstring& e

#define exo_msg() QString::fromStdWString(e.c_str())

#define catch_display_ex()  catch(const std::wstring& e)\
						    {						    \
								QMessageBox::critical(this, STR_DESPOT_ERROR, QString::fromStdWString(e.c_str()));\
						    }\
							catch(...)\
							{\
								QMessageBox::critical(this, STR_DESPOT_ERROR, "Unknown exception occurred.");\
							}

#define catch_display_ex_in(widget)  catch(const std::wstring& e)\
									 {									 \
									  	 QMessageBox::critical(widget, STR_DESPOT_ERROR, QString::fromStdWString(e.c_str()));\
									 }\
									 catch(...)\
									 {\
								 		 QMessageBox::critical(widget, STR_DESPOT_ERROR, "Unknown exception occurred.");\
									 }


#define catch_display_xml_ex()  catch(QXmlParseException* e)\
								{\
									QString message = tr("An XML error occurred: \"%1\". Line %2, Column %3").arg(e->message(), QVariant(e->lineNumber()).toString(), QVariant(e->columnNumber()).toString());\
									\
									QMessageBox::critical(this, STR_DESPOT_ERROR, message);\
									delete e;\
								}

#define catch_display_xml_ex_in(widget)  catch(QXmlParseException* e)\
								{\
									QString message = tr("An XML error occurred: \"%1\". Line %2, Column %3").arg(e->message(), QVariant(e->lineNumber()).toString(), QVariant(e->columnNumber()).toString());\
									\
									QMessageBox::critical(widget, STR_DESPOT_ERROR, message);\
									delete e;\
								}

#define catch_display_all() catch(...)\
							{\
								QMessageBox::critical(this, STR_DESPOT_ERROR, "Unknown exception occurred.");\
							}

#define display_ex()	QMessageBox::critical(this, STR_DESPOT_ERROR, QString::fromStdWString(e.c_str()));

#define display_ex_in(widget)	QMessageBox::critical(widget, STR_DESPOT_ERROR, QString::fromStdWString(e.c_str()));

/* Exception Macros Usage
   throw EX("This is my exception")
   ...

   try
   {
	...
   }
   catch(EXO)
   {
		QMessageBox::critical(this, STR_DESPOT_ERROR, EXO_MSG);
   }

   OR

   try
   {
   }
   catch_display_ex()
*/




//Constants_____________________________________
const QSize cToolBarIconSize(20,20);


//Typedefs______________________________________


//Strings
#define STR_DESPOT					tr("DESpot")

#define STR_DESPOT_ERROR			tr("DESpot Error")

#define STR_DESPOT_WARNING			tr("DESpot Warning")

#define STR_STATE_NAME_MANDATORY	tr("The state name is manatory. Please provide a valid name.")

#define STR_STATE_NAME_MANDATORY_EX tr("The state name is manatory. To add a state please give it a name or click Cancel to exit the dialog.")

#define STR_STATE_DEL_CONFIRM		tr("You are about to delete the current state. Do you want to continue?")

#define STR_TRANS_DEL_CONFIRM		tr("You are about to delete the current transition. Do you want to continue?")

#define STR_SELF_TRANS_DEL_CONFIRM	tr("You are about to delete the current global self-loop. Do you want to continue?")

#define STR_EVENT_NAME_MANDATORY	tr("The event name is manatory. Please provide a valid name.")

#define STR_EVENT_NAME_MANDATORY_EX tr("The event name is manatory. To add an event please give it a name or click Cancel to exit the dialog.")

#define STR_EVENT_DEL_CONFIRM		tr("You are about to delete the current event. Do you want to continue?")

#define EVENT_TYPE_INVALID_LABEL    tr("The event type is invalid. Please provide correct event type (d = default; a = answer; r = request, ld = l-data).")

#define STR_TRANS_FROM_STATE_MANDATORY	tr("The transition \"from state\" name is manatory. Please provide a valid state name.")

#define STR_TRANS_FROM_STATE_NOT_FOUND	tr("The state \"%1\" was not found. Please provide the name of an existing state.").arg

#define STR_TRANS_EVENT_MANDATORY	tr("The transition event name is manatory. Please provide a valid event name.")

#define STR_TRANS_EVENT_NOT_FOUND	tr("The event \"%1\" was not found. Please provide the name of an existing event.").arg

#define STR_TRANS_TO_STATE_MANDATORY	tr("The transition \"<i>to state</i>\" name is manatory. Please provide a valid state name.")

#define STR_TRANS_TO_STATE_NOT_FOUND	tr("The state \"%1\" was not found. Please provide the name of an existing state.").arg

#define STR_NON_DETERMINISTIC_TRANS_CHANGE	tr("Transition ( %1 ; %2; %3 ) is non-deterministic. Cannot change transition.").arg

#define STR_NON_DET_WITH_SELF_TRANS_CHANGE	tr("Transition ( %1 ; %2; %3 ) is non-deterministic. The event \"%2\" is self-looped. Cannot change transition.").arg

#define STR_TRANSITION_ALREADY_EXISTS_CHANGE tr("Transition ( %1 ; %2; %3 ) already exists. Cannot change transition.").arg

#define STR_TRANSITION_ALREADY_EXISTS_ADD tr("Transition ( %1 ; %2; %3 ) already exists. Cannot add transition.").arg

#define STR_NON_DETERMINISTIC_TRANS_ADD	tr("Transition ( %1 ; %2; %3 ) is non-deterministic. Cannot add transition.").arg

#define STR_NON_DET_WITH_SELF_TRANS_ADD	tr("Transition ( %1 ; %2; %3 ) is non-deterministic. The event &quot;%2&quot; is self-looped. Cannot add transition.").arg

#define STR_SELF_TRANS_ALREADY_EXISTS_ADD tr("A global self-loop transition already exists for event \"%1\".").arg

#define STR_SELF_TRANS_NON_DET_ADD tr("Adding a global self-loop transition for event \"%1\" would cause non-determinism. Cannot add transition.").arg

#define STR_OPEN_DES_AS_DLG_TITLE tr("Open DES")

#define STR_SAVE_DES_AS_DLG_TITLE tr("Save DES")

#define STR_PRINT_TO_FILE_DES_DLG_TITLE tr("Print DES to File")

#define STR_PRINT_TO_FILE_PROJ_DLG_TITLE tr("Print Project to File")

#define STR_TXT_FILE_DLG_FILTER tr("Text Files (*.txt)")

#define STR_DES_FILE_DLG_FILTER tr("Des Files (*.des)")

#define STR_NO_STATE_SELECTED tr("No state selected")

#define STR_UNNAMED_DES tr("Unnamed DES")

#define STD_STR_UNNAMED_DES L"Unnamed DES"

#define STR_DES_NAME_DLG_TITLE tr("Des Name")

#define STR_DES_NAME_DLG_LABEL tr("Select DES name:")

#define STR_DES_NAME_FOR_DUPLICATE_DLG_LABEL tr("Select the name of the DES:")

#define STR_DES_TYPE_DLG_TITLE tr("Des Type")

#define STR_DES_TYPE_DLG_LABEL tr("Select DES type:")

#define STR_DES_TYPE_REGULAR tr("Regular")

#define STR_DES_TYPE_SUBSYSTEM tr("Subsystem")

#define STR_DES_TYPE_INTERFACE tr("Interface")

#define STR_UNNAMED_PROJECT tr("Unnamed Project")

#define STR_FLAT_PROJ_EDITOR tr("F-Project Editor")

#define STR_HIER_PROJ_EDITOR tr("H-Project Editor")

#define STR_FLAT_PROJECT tr("Flat Project")

#define STR_HIER_PROJECT tr("HISC Project")

#define STR_PROJ_STRUCT_HEADER tr("Project Structure")

#define STR_PROJ_STRUCT_SUP_ITEM tr("Supervisor")

#define STR_PROJ_STRUCT_SUP_ITEM_TOOLTIP tr("Supervisor Level - %1 DES").arg

#define STR_PROJ_STRUCT_PLANT_ITEM tr("Plant")

#define STR_PROJ_STRUCT_PLANT_ITEM_TOOLTIP tr("Plant Level - %1 DES").arg

#define STR_NEW_FLAT_PROJ_DLG_TITLE tr("New Flat Project")

#define STR_NEW_FLAT_PROJ_DLG_LABEL tr("Please enter the name of the project:")

#define STR_NEW_HIER_PROJ_DLG_TITLE tr("New HISC Project")

#define STR_NEW_HIER_PROJ_DLG_LABEL tr("Please enter the name of the project:")

#define STR_DES_NAME_EMPTY tr("Cannot add a DES with an empty name, please provide a name")

#define STR_PROJ_NAME_ALREADY_EXISTS tr("The name is already used in the project. Please choose another name")

#define STR_DES_FILE_NAME_EMPTY tr("Please specify a file name or select to add a new DES")

#define STR_DES_FILE_DOES_NOT_EXIST tr("There exists no file with the specified file name, \"%1\". Please select an existing file.").arg 

#define FLAT_NON_BLOCK_NOT_VERIFIED tr("Unknown")

#define FLAT_NON_BLOCK_YES tr("Yes")

#define FLAT_NON_BLOCK_NO tr("No")

#define FLAT_CTRL_NOT_VERIFIED tr("Unknown")

#define FLAT_CTRL_YES tr("Yes")

#define FLAT_CTRL_NO tr("No")

#define STR_HIER_PROJ_STRUCT_HEADER tr("Project Structure")

#define STR_HIER_PROJ_IC_HEADER tr("IC")

#define STR_HIER_PROJ_NB_HEADER tr("NB")

#define STR_HIER_PROJ_CTRL_HEADER tr("C")

#define STR_LEVEL_DES_HEADER tr("Project Des Details")

#define STR_LEVEL_DES_STATUS_HEADER tr("Status")

#define STR_NO_SUBSYS_INTERF_SELECTED tr("No subsystem or interface selected")

#define STR_LEVEL_VIEW_PROJ_STRUCT_HEADER tr("Project Structure")

#define STR_HIGH_LEVEL_ITEM_TEXT tr("High Level")

#define STR_I_LEVEL_ITEM_TEXT tr("Interface Level")

#define STR_LOW_LEVEL_ITEM_TEXT tr("Low Level")

#define STR_ADD_HIGH_SUBSYS_DLG_TITLE tr("Add Subsytem")

#define STR_ADD_HIGH_SUBSYS_DLG_LABEL tr("Please specify the name of the high-level subsystem")

#define STR_DEFAULT_HIGH_SUBSYS_NAME tr("High-Level Subsystem")

#define STR_ADD_INTERF_DLG_TITLE tr("Add Interface")

#define STR_ADD_INTERF_DLG_LABEL tr("Please specify the name of the interface")

#define STR_SUBSYS_ITEM_TOOLTIP tr("%1 - %2 plant DES and %3 supervisor DES").arg

#define STR_INTERF_ITEM_TOOLTIP tr("%1 - %2 DES").arg

#define STR_SUBSYS_NAME_EMPTY tr("Please provide a name for the subsystem")

#define STR_INTERF_NAME_EMPTY_SHORT tr("Please provide a name for the interface")

#define STR_INTERF_NAME_EMPTY tr("Please select an interface with which the subsystem is to communicate with the high level subystem")

#define STR_INTERF_ALREADY_DEPENDENT tr("This interface is already used by a low-level subsystem")

#define STR_RENAME_SUBSYS_DLG_TITLE tr("Rename subsystem")

#define STR_RENAME_SUBSYS_DLG_LABEL tr("Please enter the new name of the subsystem")

#define STR_SUBSYS_RENAME_EMPTY tr("The name of a subsystem cannot be emptry. The subsystem will not be renamed")

#define STR_RENAME_INTERF_DLG_TITLE tr("Rename interface")

#define STR_RENAME_INTERF_DLG_LABEL tr("Please enter the new name of the interface")

#define STR_INTERF_RENAME_EMPTY tr("The name of an interface cannot be empty. The interface will not be renamed")

#define STR_DES_VIEW_SUPERVISOR tr("Supervisor")

#define STR_DES_VIEW_SUPERVISOR_TOOLTIP tr("Supervisor - %1 DES").arg

#define STR_DES_VIEW_PLANT tr("Plant")

#define STR_DES_VIEW_PLANT_TOOLTIP tr("Plant - %1 DES").arg

#define STR_LEVEL_VIEW_SUPERVISOR tr("Supervisor")

#define STR_LEVEL_VIEW_PLANT tr("Plant")

#define STR_HIER_VIEW_DES_TOOLTIP tr("%1 - %2").arg

#define STR_LEVEL_VIEW_DES_TOOLTIP tr("%1 - %2").arg

#define STR_FLAT_VIEW_DES_TOOLTIP tr("%1 of %2 - %3").arg

#define STR_LEVEL_VIEW_SUPERVISOR tr("Supervisor")

#define STR_LEVEL_VIEW_SUPERVISOR_TOOLTIP tr("Supervisor - %1 DES").arg

#define STR_LEVEL_VIEW_PLANT tr("Plant")

#define STR_LEVEL_VIEW_PLANT_TOOLTIP tr("Plant - %1 DES(s)").arg

#define STR_ADD_NEW_INTERFACE tr("The interface name was not found. Do you want to add a new interface with this name?")

#define STR_INTERF_NAME_ALREADY_USED_IN_PROJECT tr("The interface name is already used in the project. Please choose another name.")

#define STR_OPEN_PROJ_DLG_TITLE tr("Open Project")

#define STR_PROJ_FILE_DLG_FILTER tr("DESpot Project Files (*.desp)")

#define STR_DELETE_ROOT_SUBSYS_WARNING tr("The root subsystem is not empty. Deleting the root subsystem will result in an empty project. All DES, interfaces and low-level subsystems will also be deleted. This action cannot be undone. Are you sure you want to continue?")

#define STR_DELETE_SUBSYS_WARNING tr("The subsystem is not empty. Deleting the subsystem will result in deleting all contained DES. This action cannot be undone. Are you sure you want to continue?")

#define STR_DELETE_INTERF_WARNING tr("The interface is not empty. Deleting the interface will result in deleting all contained DES and any low-level subsystems dependent on it. This action cannot be undone. Are you sure you want to continue?")

#define STR_SAVE_PROJ_AS_DLG_TITLE tr("Save Project")

#define STR_PROJ_FILE_DLG_FILTER tr("DESpot Project Files (*.desp)")

#define STR_PROJ_NAME_DLG_TITLE tr("Project Name")

#define STR_PROJ_NAME_DLG_LABEL tr("Select project name:")

#define STR_NO_DES_SELECTED tr("Select a DES in the project structure")

#define STR_SAVE_MODIFIED_PROJECT tr("Do you want to save the changes to \"%1\" project?").arg

#define STR_SAVE_MODIFIED_DES tr("Do you want to save the \"%1\" changes?").arg

#define STR_SAVE_MODIFIED_PROJ_DES tr("Do you want to commit the \"%1\" changes to file?").arg

#define STR_COMMIT_LABEL tr	("Commit")

#define STR_COMMIT_LATER_LABEL tr(" Commit Later ")

#define STR_REVERT_TO_FILE_LABEL tr(" Revert to File ")

#define STR_SAVE_MODIFIED_DES_REMAINING tr(" (%2 remaining)").arg

#define STR_PROJ_PROP_CHECKED_OK tr("The project was checked succesfully.")

#define STR_PROJ_PROP_CHECKED_FAIL_STM tr("The project check resulted in errors.\nSee the output tab for details.")

#define STR_PROJ_PROP_CHECKED_FAIL tr("The project check resulted in errors. Would you like to see the output?")

#define STR_PROJECT_CLEANED tr("Project cleaned. All precomputed information has been deleted.")

#define STR_EVENT_POOL_EVENT_DEL_CONFIRM	tr("Are you sure you want to delete event \"%1\" from DES \"%2\"?").arg

#define STR_INTERF_SYNC_ERROR tr("The interface selected must have at least two DES.")

#define STR_SUBSYS_SYNC_ERROR tr("The subsys selected must have at least two DES.")

#define STR_PLANT_SYNC_ERROR tr("The PLANT selected must have at least two DES.")

#define STR_SUP_SYNC_ERROR tr("The SUPERVISOR selected must have at least two DES.")

#define STR_PROJ_SYNC_ERROR tr("The project must have at least two DES.")

#define STR_COMPONENT_SYNC_ERROR tr("Please select the project, a subsystem, a plant, a supervisor or an interface.")

#define STR_DELETE_DES_FROM_PROJ tr("Are you sure you want to remove \"%1\" DES from the project?").arg

#define STR_INPUT_DES_INVALID tr("Input DES \"%1\" is either not valid or not verified to be valid.").arg
