/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "DespotTreeWidget.h"
#include "DesEvent.h"

namespace DESpot
{
	class Des;

	class EventViewerWidget	: public DespotTreeWidget
	{
		Q_OBJECT

		public:
			EventViewerWidget(QWidget* parent = 0);
			virtual ~EventViewerWidget(void);
		
		public:
			virtual void initWidget();			
			
			void setAllowEdit(bool allowEdit = true);
			
			void loadEvents(Des* des);

			bool findEventItem(const QString& eventName, QTreeWidgetItem*& out_foundItem);

			QTreeWidgetItem* addEvent(const DesEvent& event);
			QTreeWidgetItem* updateEvent(const DesEvent& event);
			void removeEvent(const DesEvent& event);

		//Signals_______________________________________
		signals:
			void onChangedCurrentEvent(const DesEvent* pNewCurrentEvent, const DesEvent* pOldCurrentEvent);
			void onChangedActiveEvent(const DesEvent* pNewCurrentEvent, const DesEvent* pOldCurrentEvent);
			void onEventClicked(const DesEvent& event);

			void onUserChangedEventName(const DesEvent& changedEvent, const std::wstring& newName);
			void onUserChangedEventAlias(const DesEvent& changedEvent, const std::wstring& newAlias);
			void onUserChangedEventCtrl(const DesEvent& changedEvent, bool newCtrl);
			void onUserChangedEventType(const DesEvent& changedEvent, EventType newType);

		//Slots_________________________________________
		protected slots:			
			void onChangedCurrentEventItem(QTreeWidgetItem* current, QTreeWidgetItem* previous);
			void onChangedActiveEventItem(QTreeWidgetItem* current, QTreeWidgetItem* previous);
			void onEventItemClicked ( QTreeWidgetItem * item, int column );
			void onEventItemChanged(QTreeWidgetItem * item, int column );
			void onEventItemNameChanged(QTreeWidgetItem * item, int column );
			void onEventItemAliasChanged(QTreeWidgetItem * item, int column );
			void onEventItemCtrlChanged( QTreeWidgetItem * item, int column );
			void onEventItemTypeChanged( QTreeWidgetItem * item, int column );

		protected:
			virtual void resizeEvent(QResizeEvent* event);

		protected:
			virtual int getColumnCount();
			virtual void getHeaders(QStringList& out_headerList);

			void setupConnections();
			virtual void resizeHeaders(int eventViewWidgWidth);

			QTreeWidgetItem* createUiItemFromEvent(const DesEvent& event);
			virtual void fillEventUiItem(QTreeWidgetItem& eventUiItem, const DesEvent& desEvent);
			virtual QString composeTooltip(QTreeWidgetItem& eventUiItem);
			
			bool isEventUiItem(QTreeWidgetItem& item);
			const DesEvent& getEventFromUiItem(QTreeWidgetItem& eventUiItem);
			QTreeWidgetItem* getUiItemFromEvent(const DesEvent& event);
			QTreeWidgetItem* getUiItemFromEvent(const DesEvent::ID& eventID);

		protected:
			enum ETypeLabelCheck
			{
				eInvalidTypeLabel, 
				eValidTypeLabel,
				eTypeLabelCorrected
			};
			
			ETypeLabelCheck isEventTypeLabelValid(const QString& typeLabel, QString* pTypeLabelCorrected = null);
			QString getTypeLabel(EventType eventType);
			QString getTypeName(const QString& typeLabel);
			EventType getTypeForLabel(const QString& typeLabel);

		protected:
			bool m_allowEdit;

		protected:
			static const int cColCount;

			static const int cEventNameColIdx;
			static const int cEventAliasColIdx;
			static const int cEventCtrlColIdx;
			static const int cEventTypeColIdx;

			static const QString cEventNameColName;
			static const QString cEventAliasColName;
			static const QString cEventCtrlColName;
			static const QString cEventTypeColName;

			static const QString cYes;
			static const QString cNo;

			static const QString cEventCtrlProp;
			static const QString cEventTypeProp;
			static const QString cEventUsedProp;

			static const QString cDefaultTypeLabel;
			static const QString cDefaultTypeAltLabel;
			static const QString cDefaultTypeName;

			static const QString cHighLevelTypeLabel;
			static const QString cHighLevelTypeAltLabel;
			static const QString cHighLevelTypeName;

			static const QString cLowLevelTypeLabel;
			static const QString cLowLevelTypeAltLabel;
			static const QString cLowLevelTypeName;

			static const QString cRequestTypeLabel;
			static const QString cRequestTypeAltLabel;
			static const QString cRequestTypeName;

			static const QString cAnswerTypeLabel;
			static const QString cAnswerTypeAltLabel;
			static const QString cAnswerTypeName;

			static const QString cLDataTypeLabel;
			static const QString cLDataTypeAltLabel;
			static const QString cLDataTypeName;

			static const QString cPropCheckSymbol;


	};

} //end of namespace DESpot

