/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ui_HierProjectEditor.h"
#include "ProjSummaryUiPart.h"

class QSpinBox;


namespace DESpot
{
	class DesHierProject;

	class HierProjSummaryUiPart: public ProjSummaryUiPart
	{
		public:
			HierProjSummaryUiPart(Ui::HierProjectEditorUI* pUiContainer, DesHierProject* pProject);
			virtual ~HierProjSummaryUiPart(void);

		private:
			DesHierProject* project();
			
			void initWidgets(Ui::HierProjectEditorUI* pUiContainer);
			
			void updateUi();
			void updateIConsistUi();
			void updateLwNonBlockUi();
			void updateLwCtrlUi();
			void updateFlatPropsUi();

		//Project Notifications_________________________
		private:
			virtual void onLowLevelSubsysAdded(const DesSubsystem& lowLevelSubsys);
			virtual void onSubsysDeleted(const std::wstring& subsysName);

			virtual void onNonBlockStatusChanged() {updateFlatPropsUi();};
			virtual void onCtrlStatusChanged() {updateFlatPropsUi();};
			virtual void onIConsistStatusChanged()  {updateIConsistUi(); }
			virtual void onLwCtrlStatusChanged()    { updateLwCtrlUi();}
			virtual void onLwNonBlockStatusChanged(){updateLwNonBlockUi();}

		//Widgets
		private:
			QSpinBox* m_projDegreeWidg;

			QLabel* m_iConsistNotChckLabel;
			QLabel* m_smryIConsistVerifiedLabel;
			QRadioButton* m_smryIConsistYesWidg;
			QRadioButton* m_smryIConsistNoWidg;
			OutputButtonGroup* m_iConsistRadioBtnGroup;
			QDateTimeEdit* m_smryIConsistDateStampWidg;
			QLabel* m_iConsistSpacer1;
			QLabel* m_iConsistSpacer2;
			QLabel* m_iConsistSpacer3;
			QLabel* m_iConsistSpacer4;

			QLabel* m_lwNonBlockNotChkLabel;
			QLabel* m_smryLwNonBlockVerifiedLabel;
			QRadioButton* m_smryLwNonBlockYesWidg;
			QRadioButton* m_smryLwNonBlockNoWidg;
			OutputButtonGroup* m_lwNonbBlockRadioBtnGroup;
			QDateTimeEdit* m_smryLwNonBlockDateStampWidg;
			QLabel* m_lwNonblockSpacer1;
			QLabel* m_lwNonblockSpacer2;
			QLabel* m_lwNonblockSpacer3;
			QLabel* m_lwNonblockSpacer4;

			QLabel* m_lwCtrlNotChkLabel;
			QLabel* m_smryLwCtrlVerifiedLabel;
			QRadioButton* m_smryLwCtrlYesWidg;
			QRadioButton* m_smryLwCtrlNoWidg;
			OutputButtonGroup* m_lwCtrlRadioBtnGroup;
			QDateTimeEdit* m_smryLwCtrlDateStampWidg;
			QLabel* m_lwCtrlSpacer1;
			QLabel* m_lwCtrlSpacer2;
			QLabel* m_lwCtrlSpacer3;
			QLabel* m_lwCtrlSpacer4;

			QLabel* m_flatNonBlockDisplay;
			QLabel* m_flatCtrlDisplay;
	};

} //end of namespace DESpot
