#include <QtCore>

#include "SimStateParser.h"

namespace DESpot
{
Node::Node(Type type, const Des* des, const DesState* sta, bool viewerVisible)
{
    this->type = type;
	this->des = des;
	this->desName = QString::fromStdWString(des->getName());
    this->state = sta;
    this->viewerVisible = viewerVisible;
    this->isBlockingDes = false;
	if(sta){
		this->stateName = QString::fromStdWString(sta->getName());
		initCol = (sta->isInit())?"X":"";
		markedCol= (sta->isMarked())?"X":"";
	}
	else
		this->stateName = "";
    parent = 0;
}

// Level, project etc. Not a des.
Node::Node(const QString &meta)
{
    this->type = MetaData;
	this->des = 0;
	this->desName = meta;
    this->stateName = "";
	this->initCol = "";
	this->markedCol = "";
	this->viewerVisible = false;
	this->isBlockingDes = false;
    parent = 0;
}

Node::~Node()
{
    qDeleteAll(children);
}

}
