/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "DesEvent.h"


namespace DESpot
{
const DesEvent::ID DesEvent::ID::cInvalidId;
const DesEvent::Index DesEvent::ID::cInvalidIndex = static_cast<Index>(-1);

const DesEvent::Props DesEvent::cUsedFlagMask				= 1;	//00000001
const DesEvent::Props DesEvent::cControllableFlagMask		= 2;	//00000010		
const DesEvent::Props DesEvent::cTypeDefaultFlagMask		= 4;	//00000100
const DesEvent::Props DesEvent::cTypeAnswerFlagMask			= 8;	//00001000
const DesEvent::Props DesEvent::cTypeRequestFlagMask		= 16;	//00010000
const DesEvent::Props DesEvent::cTypeLDataFlagMask			= 32;	//00100000
const DesEvent::Props DesEvent::cTypeHighLevelFlagMask		= 64;	//01000000
const DesEvent::Props DesEvent::cTypeLowLevelFlagMask		= 128;	//10000000
															  
const DesEvent::Props DesEvent::cDefaultEventProps		= 4;	//default uncontrollable event

NameValidator DesEvent::m_nameValidator(new AlphaNumValidator(new WordSepValidator()));

DesEvent::DesEvent(void) : m_id(0)
{
	//By default an event is unused, of type default and it is uncontrollable
	setProps(cDefaultEventProps);
	childLDEventFlag = false;
}

//_________________________________________________________________________________________________

DesEvent::DesEvent(DesEvent::ID eventId) : m_id(eventId)
{
	//By default a event is not the initial one, is non-marked and it is not reachable
	setProps(cDefaultEventProps);
	childLDEventFlag = false;
}

//_________________________________________________________________________________________________

DesEvent::DesEvent(DesEvent::ID eventId, const DesEvent& otherEvent) : m_id(eventId)
{
	*this = otherEvent;
	childLDEventFlag = false;
}

//_________________________________________________________________________________________________

DesEvent::DesEvent(const DesEvent& otherEvent)
{		
	*this = otherEvent;
	childLDEventFlag = false;
}

//_________________________________________________________________________________________________

DesEvent::~DesEvent(void)
{
}

//_________________________________________________________________________________________________

DesEvent& DesEvent::operator= (const DesEvent& otherEvent)
{
	if (this == &otherEvent)
		return *this; //the same already

	m_name  = otherEvent.m_name;
	m_alias = otherEvent.m_alias;
	m_props = otherEvent.m_props;

	//note that the ID cannot be copied as it is only assigned once at creation time and never changed
	//to obtain an exact copy of the event you have to use the copy constructor and create a copy from the start
	return *this;
}
} //end of namespace DESpot
