/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QTableWidget>
#include "CommonDefinitions.h"

namespace DESpot
{
	class Des;

	class DesDataTableWidget : public QTableWidget
	{
		public:
			DesDataTableWidget(QWidget* parent = null);
			virtual ~DesDataTableWidget(void);

		public:
			void setupWidget(int colCount);			
			
			virtual void loadData(Des* des, bool highLevelDes = false) = 0;

			int calculateRowCount(const int itemCount, const int colCount);

			void calculateNextRowAndCol(int& io_row, int& io_col);

			void autoResizeTableRows();

		protected:
			virtual void resizeEvent(QResizeEvent* event);

		protected:
			//The number of columns the table will have
			int m_tableColCount;

		public:
			static const QString cYes;
			static const QString cNo;
			static const QString cUnknown;
	};
} //end of namespace DESpot

