/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "DesProject.h"
#include "Des.h"

namespace DESpot
{

	class DesProjectNotifications
	{
		public:
			virtual void onProjectNameChanged(const std::wstring& /*newName*/, const std::wstring& /*oldName*/) {};
			
			virtual void onIntegStatusChanged() {};
			virtual void onNonBlockStatusChanged() {};
			virtual void onCtrlStatusChanged() {};

			virtual void onIConsistStatusChanged() {};
			virtual void onIConsistStatusChecked() {};
			virtual void onInterfIConsistStatusChanged(const DesInterface& /*interf*/) {};
			virtual void onSubsysIConsistStatusChanged(const DesSubsystem& /*subsys*/) {};
			
			virtual void onLwCtrlStatusChanged() {};
			virtual void onLwCtrlStatusChecked() {};
			virtual void onSubsysLwCtrlStatusChanged(const DesSubsystem& /*subsys*/) {};
			
			virtual void onLwNonBlockStatusChanged(){};
			virtual void onLwNonBlockStatusChecked(){};
			virtual void onSubsysLwNonBlockStatusChanged(const DesSubsystem& /*subsys*/){};

			virtual void onProjectCleaned() {};

		//Des notifications
		public:
			virtual void onDesNameChanged(const Des& /*des*/, const std::wstring& /*oldName*/) {};

			//Notification fired by flat projects when a component is added
			virtual void onDesAdded(const Des& /*des*/, DesLevel /*desLevel*/) {};
			virtual void onRemovingDes(const Des& /*des*/, DesLevel /*desLevel*/) {};
			virtual void onDesRemoved(const std::wstring& /*desName*/, DesLevel /*desLevel*/) {};

			//Notifications fired by HISC projects when a component is added
			virtual void onDesAdded(const Des& /*des*/, DesLevel /*desLevel*/, const DesSubsystem& /*subsys*/){};
			virtual void onDesAdded(const Des& /*des*/, const DesInterface& /*interf*/){};
			
			virtual void onRemovingDes(const Des& /*des*/, DesLevel /*desLevel*/, const DesSubsystem& /*subsys*/) {};
			virtual void onRemovingDes(const Des& /*des*/, const DesInterface& /*interf*/) {};

			virtual void onDesRemoved(const std::wstring& /*desName*/, DesLevel /*desLevel*/, const DesSubsystem& /*subsys*/) {};
			virtual void onDesRemoved(const std::wstring& /*desName*/, const DesInterface& /*interf*/) {};

		//Subsystem / Interface notifications
		public:
			virtual void onHighLevelSubsysAdded(const DesSubsystem& /*highLevelSubsys*/) {};
			virtual void onInterfaceAdded(const DesInterface& /*interf*/) {};
			virtual void onLowLevelSubsysAdded(const DesSubsystem& /*lowLevelSubsys*/) {};
			virtual void onDependencyAdded(const DesSubsystem& /*subsys*/, 
										   const DesInterface& /*interf*/, 
										   const DesSubsystem& /*dependent*/) {};

			virtual void onSubsysRenamed(const DesSubsystem& /*subsys*/) {};
			virtual void onInterfRenamed(const DesInterface& /*interf*/) {};

			virtual void onDeletingSubsys(const DesSubsystem& /*subsys*/) {};
			virtual void onSubsysDeleted(const std::wstring& /*subsysName*/) {};
			
			virtual void onDeletingInterf(const DesInterface& /*interf*/) {};
			virtual void onInterfDeleted(const std::wstring& /*interfName*/) {};

		//Event Pool Notifications
		public:
			virtual void onProjectEventPoolChanged() {};

		protected:
			DesProjectNotifications(void){};
			virtual ~DesProjectNotifications(void){};
	};

} //end of namespace DESpot
