/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "EventPoolForm.h"
#include "MainForm.h"
#include "ProjectEditor.h"
#include "CommonDefinitions.h"
#include "EventPoolWorkspace.h"
#include "EventPoolUiPart.h"
#include "DesProject.h"

namespace DESpot
{

const QString EventPoolForm::cEventPoolTitle = "Project Event Set";


EventPoolForm::EventPoolForm(MainForm* pMainForm, ProjectEditor* projEditorOwner): 
		DespotForm(pMainForm, this, projEditorOwner, eProjectEventPool)

{
	//create the workspace shown in form
	m_pWorkspace = new EventPoolWorkspace(projEditorOwner->project(), this);
	updateWindowTitle();
}

//_________________________________________________________________________________________________

EventPoolForm::~EventPoolForm(void)
{
	if (m_pWorkspace)
	{
		delete m_pWorkspace;
		m_pWorkspace = null;
	}
}

//_________________________________________________________________________________________________

void EventPoolForm::closeEvent(QCloseEvent *event)
{
	if (onCloseForm() == false)
	{
		event->ignore();
		return;
	}
}

//_________________________________________________________________________________________________

void EventPoolForm::resizeEvent(QResizeEvent* event)
{
	QMainWindow::resizeEvent(event);	

	m_pWorkspace->resize(event);
}

//_________________________________________________________________________________________________

ProjectEditor* EventPoolForm::projEditorOwner()
{
	return dynamic_cast<ProjectEditor*>(m_owner);
}

//_________________________________________________________________________________________________

void EventPoolForm::updateWindowTitle()
{
	QString projName = QString::fromStdWString(projEditorOwner()->project()->getName());
	setWindowTitle(cEventPoolTitle + " - " + projName);
}

} //end of namespace DESpot
