#pragma once

#include <map>
#include <deque>
#include <vector>
#include <string>
#include <iostream>
#include <QMessageBox>
#include <sstream>
#include "DesAlgo.h"
#include "DesState.h"
#include "DesEvent.h"
#include "DesProject.h"
#include "TireStorage.h"
#include "ProductTransitionMap.h"
#include "PendingStructure.h"


namespace DESpot
{
	class Des;

	class MeetAlgo: virtual public DesAlgo
	{
       //--------------type  define-----------------------

	public:
		typedef std::vector<const Des*> DesSet;
		typedef DesSet::iterator DesSetIt;
		typedef DesSet::const_iterator DesSetCIt;
	    typedef std::vector<short> SrcStateTuple; 
	    typedef std::deque<SrcStateTuple*> SourceStateList;


         //-----------------data define------------------------------
	public:
		Des*   m_outDes;
		DesSet m_inDesSet;
		bool m_checkDesIntegrity;
	public:
		static const std::wstring cMeetDesc;
		static const std::wstring cMeetIntegError;
	public:
	    short DesNum;
        short EventNum;
        short StateMaxNum;
        short ***transitionMatrix;
	    SourceStateList m_pendingList;
	    MeetSynTrie *turpleStorage;
        ProductTransitionMap *tranMap;
		PendingList *main_pendinglist;

     //--------------function define----------------------------
	public:
		MeetAlgo(bool checkIntegrity = true);//
		MeetAlgo(const Des* des1, const Des* des2, bool checkIntegrity = true);//
		MeetAlgo(DesProject::DesIteratorPtr desIterator, bool checkIntegrity = true);//
		virtual ~MeetAlgo(void);//
	public:
		void addInputDes(const Des* inDes);//
		void addInputDes(DesProject::DesIteratorPtr desIterator);//
		Des* getOutputDes();
	    Des* returnResult();



		virtual void createOutputDes();
	    virtual std::wstring composeOutputDesName();

	public:
		virtual bool runAlgo();
	public:
		virtual void prepareRun();

	public:
		virtual void loadProductDes();
		void createInitialStateTuple();


		void addStateToOutputDes( SrcStateTuple *sl, bool isInitial);
		DesState& getStateFromOutputDes(SrcStateTuple *sl);

	};
}   //End of namespace DESpot

