/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "NewDesDialog.h"

namespace DESpot
{

NewDesDialog::NewDesDialog(QWidget *parent /*= null*/): QDialog(parent),
	 m_desName(STR_UNNAMED_DES),
	 m_desType(eRegularDes)
{
	setupUi(this);
	m_desNameWidg->setFocus();
}

//Initializes the dialog to show the given name and type
NewDesDialog::NewDesDialog(const std::wstring& desName, DesType desType /*= eRegularDes*/, QWidget *parent /*= null*/):
		QDialog(parent), 
		m_desName(QString::fromStdWString(desName)), 
		m_desType(desType)
{
	setupUi(this);
	m_desNameWidg->setFocus();
}

NewDesDialog::~NewDesDialog(void)
{
}


//Returns the name chosen by the user
std::wstring NewDesDialog::getDesName() const
{
	return m_desName.toStdWString();
}

//Returns the type chosen by the user
DesType NewDesDialog::getDesType() const
{
	return m_desType;
}

void NewDesDialog::accept()
{
	m_desName = m_desNameWidg->text();
	if (m_desName.isEmpty())
	{
		m_desName = STR_UNNAMED_DES;
	}

	//if the order of items in the combo-box changes this code will need to be updated
	switch(m_desTypeWidg->currentIndex())
	{
		case 0:
			m_desType = eRegularDes;
			break;

		case 1:
		case 3:
			m_desType = eSubsystemDes;
			break;
		
		case 2:
			m_desType = eInterfaceDes;
			break;

		default:
			assert(false); //unknown index)
			m_desType = eRegularDes;
			break;
	}

	QDialog::accept();
}

void NewDesDialog::reject()
{
	QDialog::reject();
}

} // end of namespace DESpot
