/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 *
 * Description: This class defines a number of common enumerations and data
 * types used throughout the distributed computation files. It also provides
 * a publicly accessable, class static boolean to keep track of whether or not
 * the GUI is enabled (for the slave processes, it's not) and to disable certain
 * graphical behaviours in the main DESpot code if it is not.
 ************************************************************************/
#pragma once

#include "DesAlgo.h"

namespace DESpot 
{

// Distributed Computation : Algorithm Identification Enum
// The order of the enums matters! do not change the order!
enum AlgEnum { FlatNB, FlatCtrl, 
			   HISCHighCtrl, HISCLowCtrl, HISCHighNB, HISCLowNB, HISCInterfLDConsist, HISCHighInterf, HISCLowInterf, 
			   BDDHighAll, BDDLowAll, BDDHighCtrl, BDDLowCtrl, BDDHighNB, BDDLowNB, BDDICheck, BDDHighIConsis, BDDLowIConsis, 
			   BDDHighSynthb, BDDLowSynthb, BDDHighSynthd, BDDLowSynthd, BDDHighSyntho, BDDLowSyntho,
			   KillProcess};

// Store the result of the various checks for a given subsystem
typedef struct
{
	int nonBlocking;
	bool NBChecked;

	int controllable;
	bool ctrlChecked;

	int iConsistent;
	bool iConsistChecked;

	DesAlgo::ErrorList NBList;
	DesAlgo::ErrorList CtrlList;
	DesAlgo::ErrorList iConsList;
	DesAlgo::ErrorList SucList;
} resultStruct;

typedef struct
{
	int result;
	DesAlgo::ErrorList errList;
} remoteCheck;

class DistCommon
{
	public:
		static bool GUI_Enabled;
};

}
