/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 *
 * Description: This module handles the triggering of the various non-BDD
 * HISC check algorithms and provides access to the generated error list.
 ************************************************************************/
#pragma once

#include <string>

#include "HierProjectPropCheck.h"

#include "LdInterfaceCheckAlgo.h"
#include "InterfImplCheckAlgo.h"
#include "IConsistAnsAcceptAlgo.h"
#include "LowSubsysIConsistAlgo.h"
#include "DesInterface.h"

#include "HighSubsysCtrlAlgo.h"
#include "LowSubsysCtrlAlgo.h"

#include "HighSubsysNonBlockAlgo.h"
#include "LowSubsysNonBlockAlgo.h"

#include "DistCommon.h"
#include "CommonDefinitions.h"

namespace DESpot
{
	class HISCHandler
	{
		public:
			HISCHandler(DesProject* project, AlgEnum alg, int subSystem);

		public:
			DesAlgo::ErrorList getErrorList();

		public:
			bool runAlg();

		private:
			bool HighCtrl();
			bool LowCtrl();
			bool HighNB();
			bool LowNB();
			bool InterfLDConsist();
			bool HighInterf();
			bool LowInterf();

		private:
			DesHierProject& m_project;
			AlgEnum m_alg;
			int m_subSystem;
			DesAlgo::ErrorList m_errList;
	};
}
