/*	Author:		Magdin Stoica
    Supervisor: Dr. Ryan Leduc

    Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering,
    Computing and Software Department,
    McMaster University
    2003 - 2007
*/

#include <QMessageBox>
#include "AddInterfaceDlg.h"
#include "InterfaceIterator.h"
#include "DesSubsystem.h"
#include "DesHierProject.h"

namespace DESpot
{

AddInterfaceDlg::AddInterfaceDlg(const DesHierProject& project, QWidget* parent /*= null*/):
        QDialog(parent), m_project(project), m_newInterface(false)
{
    setupUi(this);
	m_interfaceNameWidg->setFocus();
    setupSubsysWidget();
}

AddInterfaceDlg::AddInterfaceDlg(const DesHierProject& project,const std::wstring& intName, QWidget* parent /*= null*/):
        QDialog(parent), m_project(project), m_newInterface(false)
{
    setupUi(this);
	m_interfaceNameWidg->setText(QString::fromStdWString(intName));
    m_interfaceNameWidg->setFocus();
    setupSubsysWidget();
}

//_________________________________________________________________________________________________

AddInterfaceDlg::~AddInterfaceDlg(void)
{
}

//_________________________________________________________________________________________________

std::wstring AddInterfaceDlg::getSubsysName() const
{
    return m_subsysName;
}

//_________________________________________________________________________________________________

std::wstring AddInterfaceDlg::getInterfName() const
{
    return m_interfName;
}

//_________________________________________________________________________________________________

void AddInterfaceDlg::setInterfName(const std::wstring& interfName)
{
    m_interfName = interfName;
}

//_________________________________________________________________________________________________

bool AddInterfaceDlg::isNewInterface() const
{
    return m_newInterface;
}

//_________________________________________________________________________________________________

void AddInterfaceDlg::setupSubsysWidget()
{
    DesHierProject::SubsysIteratorPtr subsysIt = m_project.createSubsysIterator();
    for(subsysIt->first(); subsysIt->isDone() == false; subsysIt->next())
    {
        const DesSubsystem& crtSubsys = subsysIt->currentItem();
       
            m_subsysNameWidg->addItem(QString::fromStdWString(crtSubsys.getName()));
        
    }

    if (m_subsysName.empty() == false)
    {
        int idx = m_subsysNameWidg->findText(QString::fromStdWString(m_subsysName));
        m_subsysNameWidg->setCurrentIndex(idx);
    }
}

//_________________________________________________________________________________________________

void AddInterfaceDlg::accept()
{
    m_subsysName = m_subsysNameWidg->currentText().toStdWString();
    
    m_interfName = m_interfaceNameWidg->text().toStdWString();
    if (m_interfName.empty())
    {
        QMessageBox::critical(this, STR_DESPOT_ERROR, STR_INTERF_NAME_EMPTY_SHORT);
        return;
    }
  
    

    QDialog::accept();
}

//_________________________________________________________________________________________________

void AddInterfaceDlg::reject()
{
    QDialog::reject();
}

} //end of namespace DESpot
