/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QStatusBar>
#include "StateEditorUiPart.h"
#include "EventEditorUiPart.h"
#include "DesEditorOutputUiPart.h"
#include "GedDesEditorOutputUiPart.h"

namespace DESpot
{

class TransRecorder: public QObject
{
	Q_OBJECT

	public:
		TransRecorder();
		~TransRecorder(void);
	
	public:
		void init(QStatusBar* statusBar);
		void initEventListWidget(EventViewerWidget* widget);
		void initStateListWidget(StateViewerWidget* widget);
		void initOutputUi(DesEditorOutputUiPart* outUi);
		void initOutputUi(GedDesEditorOutputUiPart* outUi);

		void startRecording();
		void stopRecording();
		void toggleRecording();
		
		bool isRecording();

	private:
		enum RecState
		{
			eNotRecording,
			eRecordFromState,
			eRecordEvent,
			eRecordToState,			
		};

		RecState nextState();

	private slots:
		void onStateSelected(const DesState&);
		void onEventSelected(const DesEvent&);

	signals:
		void transitionRecorded(const DesTransition& trans);
		void recordingCancelled();

	private:
		RecState m_recState;

		DesTransition m_trans;

		StateViewerWidget* m_stateListWidg;
		EventViewerWidget* m_eventListWidg;
		DesEditorOutputUiPart* m_outUi;
		QStatusBar* m_statusBar;

	private:
		static const QString cRecordingStartedMsg;
		static const QString cStartStateMsg;
		static const QString cSelectStartStateStatus;
		static const QString cRecordingStoppedMsg;
		static const QString cEventLabelMsg;
		static const QString cSelectEventStatus;
		static const QString cTransRecordedMsg;
		static const QString cRecordingCancelErr;
		static const QString cEndStateMsg;
		static const QString cSelectEndStateStatus;

};

} //end of namespace DESpot
