/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ProjectEditor.h"
#include "CommonDefinitions.h"
#include "DistHandler.h"

#ifdef __ENABLE_DIST__
#include <unistd.h>
#include <sys/time.h>
#endif

namespace DESpot
{

	class MainForm;
	class DesHierProject;
	class HierProjectWorkspace;
	class DesSubsystem;
	class DesInterface;
	class Des;

	class HierProjectEditor : public ProjectEditor
	{
		Q_OBJECT

		public:
			HierProjectEditor(const QString& projName, MainForm* pMainForm);
			HierProjectEditor(DesProject* project, MainForm* pMainForm);
			virtual ~HierProjectEditor(void);

	
		
		// Added by RJL - remove when bddhisc
		//integrated with despot
		//Implementation methods
		protected:
			bool attemptExportToBDDhisc();

		// remove to here - RJL

		protected slots:
			virtual void onDisplayEventPool();
//add by bini
			void onInstantiateTemplate();
			void onDeleteInstantiation(bool askConfirm = true);
			void onRegenerateInstantiation();
			void onEditInst();

		private slots:
			virtual void onCheckProjectIntegrity();
			virtual void onCheckProject();

			void onAddHighLevelSubsystem();
			void onAddInterface();
			void onAddLowLevelSubsystem();
			void onProjCompRename();
			void onProjCompDelete();
		    
			virtual void onAddDes();

			void onRunContextSyncProductTool();
			void onRunCheckInterfTool();
			void onRunSubsysIConsistTool();
			void onRunProjIConsistTool();
			void onRunSubsysNonblockingTool();
			void onRunLevelWiseNonblockingTool();
			void onRunSubsysCtrlTool();
			void onRunSubsysSimulationActTool();
			void onRunLevelWiseCtrlTool();
			void onRunLevelWiseSynthesisTool();

			#ifdef __ENABLE_BDD__
				void onRunBddNonBlockingTool();
				void onRunBddMultiCtrlTool();
				void onRunBddCheckInterfTool();
				void onRunBddSubsysIConsistTool();
				void onRunBddCheckAllTool();
				void onRunBddProjIConsistTool();
				void onRunBddSubsysNonblockingTool();
				void onRunBddLevelWiseNonblockingTool();
				void onRunBddSubsysCtrlTool();
				void onRunBddLevelWiseCtrlTool();
				void onRunBddLevelWiseSynthesisTool();
				void onRunBDDSubsysLWSynTool();
			#endif

			void onChangedCurrentSubsys(const DesSubsystem* pCrtSubsys, const DesSubsystem* pOldCrtSubsys);
			void onChangedCurrentInterf(const DesInterface* pCrtInterf, const DesInterface* pOldCrtInterf);

			//Added by Adam for bddExport
			void onExportToBDDhisc();

			//Added by David for Distributed tools
			void onRunDistCheckAll();
			void onRunDistLWNB();
			void onRunDistLWCtrl();
			void onRunDistIConsist();

			void onRunDistBDDCheckAll();
			void onRunDistBDDLWNB();
			void onRunDistBDDLWCtrl();
			void onRunDistBDDIConsist();

			void onRunDistBDDSynth();

		private:
			DesHierProject* project();
			HierProjectWorkspace* workspace();
			void setupConnections();
			
		private:
			const DesSubsystem* m_pCrtSubsys;
			const DesInterface* m_pCrtInterf;
	};

} //end of namespace DESpot
