#pragma once
#include "Instantiation.h"
#include "TemplateNameParser.h"
namespace DESpot
{
	NameValidator Instantiation::m_nameValidator(new AlphaNumValidator(new WordSepValidator()));

	Instantiation::Instantiation(void)
	{

	}

	Instantiation::Instantiation(const std::wstring name,DesLevel deslevel,TemplateNameParser::TemplateParameter* parameter,InputType in_type,Des* templatedes,std::vector<std::wstring> rangeinput,std::wstring tupleinput)
	{
		setName(name);
		m_level=deslevel;
		m_parameter=parameter;
		m_in_type=in_type;
		m_templatedes=templatedes;
		m_rangeinput=rangeinput;
		m_tupleinput=tupleinput;
		
	}

	Instantiation::~Instantiation(void)
	{
	
	}

	void Instantiation::setName(const std::wstring& newName)
	{
		if(m_nameValidator.validate(newName))
		{
			//std::wstring oldName = m_name;

			m_name = newName;

		/*	if (newName != oldName)
			{
				onNameChanged(oldName, newName);
			}
*/
		}
		else
		{
			std::wstring message = L"Invalid Instantiation name (";
			message += newName;
			message += L"). Use an alpha-numeric string (a-z;A-Z;0-9;.-_)";
			throw message;
		}
	}

	std::wstring Instantiation::getName() const
	{
		return m_name;
	}
	
	std::wstring Instantiation::getName()
	{
		return m_name;
	}

	DesLevel Instantiation::getLevel() const
	{
		return m_level;
	}
	
	void Instantiation::setParameter(TemplateNameParser::TemplateParameter* par) 
	{
		m_parameter=par;
	}
	
	TemplateNameParser::TemplateParameter* Instantiation::getParameter() 
	{

		return m_parameter;
	}
	
	TemplateNameParser::TemplateParameter* Instantiation::getParameter() const
	{
		return m_parameter;
	}
		
	InputType Instantiation::getInputType() const
	{
		return m_in_type;
	}
	
	const Des* Instantiation::getTemplateDes() const
	{
		return m_templatedes;
	}
	
	Des* Instantiation::getTemplateDes()
	{
		return m_templatedes;
	}

	unsigned int Instantiation::subscribe(DesNotifications* pListener)
	{
		m_instListeners.push_back(pListener);
		return m_instListeners.size() - 1;
	}
	
	void Instantiation::unsubscribe(unsigned int cookie)
	{
		if (cookie >= m_instListeners.size())
			throw EX("Invalid cookied. Cannot unsubscribe")

		m_instListeners[cookie] = null;
	}
	
	void Instantiation::setInput(std::vector<std::wstring> in)
	{
		if(m_in_type==eRange)
		{	
			m_rangeinput=in;
		}
		if(m_in_type==eTuple)
		{
			m_tupleinput=in[0];
		}
	}
	

	std::vector<std::wstring> Instantiation::getRangeInput()
	{
		return m_rangeinput;
	}
	
	std::wstring Instantiation::getTupleInput()
	{
		return m_tupleinput;
	}
}
