/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QSpinBox>
#include <QLabel>
#include <QRadioButton>
#include <QButtonGroup>
#include <QDateTimeEdit>
#include "HierProjSummaryUiPart.h"
#include "DesHierProject.h"

namespace DESpot
{

HierProjSummaryUiPart::HierProjSummaryUiPart(Ui::HierProjectEditorUI* pUiContainer, DesHierProject* pProject):
	ProjSummaryUiPart(pUiContainer, pProject)
{
	initWidgets(pUiContainer);
	updateUi();
}

//_________________________________________________________________________________________________

HierProjSummaryUiPart::~HierProjSummaryUiPart(void)
{
}

//_________________________________________________________________________________________________

DesHierProject* HierProjSummaryUiPart::project()
{
	return dynamic_cast<DesHierProject*>(m_pProject);
}

//_________________________________________________________________________________________________

void HierProjSummaryUiPart::onLowLevelSubsysAdded(const DesSubsystem& /*lowLevelSubsys*/)
{
	//A low level subsystem has been added thus, the degree has changed
	m_projDegreeWidg->setValue(project()->getDegree());
}

//_________________________________________________________________________________________________

void HierProjSummaryUiPart::onSubsysDeleted(const std::wstring& /*subsysName*/)
{
	//A low level subsystem has been added thus, the degree has changed
	m_projDegreeWidg->setValue(project()->getDegree());
}

//_________________________________________________________________________________________________

void HierProjSummaryUiPart::initWidgets(Ui::HierProjectEditorUI* pUiContainer)
{
	m_projDegreeWidg = pUiContainer->m_projDegreeWidg;

	m_iConsistNotChckLabel = pUiContainer->m_iConsistNotChckLabel;
	m_smryIConsistVerifiedLabel = pUiContainer->m_smryIConsistVerifiedLabel;	
	m_smryIConsistYesWidg = pUiContainer->m_smryIConsistYesWidg;
	m_smryIConsistNoWidg = pUiContainer->m_smryIConsistNoWidg;
	m_iConsistRadioBtnGroup = new OutputButtonGroup(this);
	m_iConsistRadioBtnGroup->addButton(m_smryIConsistYesWidg);
	m_iConsistRadioBtnGroup->addButton(m_smryIConsistNoWidg);	
	m_smryIConsistDateStampWidg = pUiContainer->m_smryIConsistDateStampWidg;
	m_iConsistSpacer1 =	pUiContainer->m_iConsistSpacer1;
	m_iConsistSpacer2 =	pUiContainer->m_iConsistSpacer2;
	m_iConsistSpacer3 =	pUiContainer->m_iConsistSpacer3;
	m_iConsistSpacer4 =	pUiContainer->m_iConsistSpacer4;
	
	m_lwNonBlockNotChkLabel			= pUiContainer->m_lwNonBlockNotChkLabel;
	m_smryLwNonBlockVerifiedLabel	= pUiContainer->m_smryLwNonBlockVerifiedLabel;
	m_smryLwNonBlockYesWidg			= pUiContainer->m_smryLwNonBlockYesWidg;
	m_smryLwNonBlockNoWidg			= pUiContainer->m_smryLwNonBlockNoWidg;
	m_lwNonbBlockRadioBtnGroup = new OutputButtonGroup(this);
	m_lwNonbBlockRadioBtnGroup->addButton(m_smryLwNonBlockYesWidg);
	m_lwNonbBlockRadioBtnGroup->addButton(m_smryLwNonBlockNoWidg);
	m_smryLwNonBlockDateStampWidg	= pUiContainer->m_smryLwNonBlockDateStampWidg;
	m_lwNonblockSpacer1 = pUiContainer->m_lwNonblockSpacer1;
	m_lwNonblockSpacer2 = pUiContainer->m_lwNonblockSpacer2;
	m_lwNonblockSpacer3 = pUiContainer->m_lwNonblockSpacer3;
	m_lwNonblockSpacer4 = pUiContainer->m_lwNonblockSpacer4;

	m_lwCtrlNotChkLabel = pUiContainer->m_lwCtrlNotChkLabel;
	m_smryLwCtrlVerifiedLabel = pUiContainer->m_smryLwCtrlVerifiedLabel;
	m_smryLwCtrlYesWidg = pUiContainer->m_smryLwCtrlYesWidg;
	m_smryLwCtrlNoWidg = pUiContainer->m_smryLwCtrlNoWidg;
	m_lwCtrlRadioBtnGroup = new OutputButtonGroup(this);
	m_lwCtrlRadioBtnGroup->addButton(m_smryLwCtrlYesWidg);
	m_lwCtrlRadioBtnGroup->addButton(m_smryLwCtrlNoWidg);
	m_smryLwCtrlDateStampWidg = pUiContainer->m_smryLwCtrlDateStampWidg;
	m_lwCtrlSpacer1 = pUiContainer->m_lwCtrlSpacer1;
	m_lwCtrlSpacer2 = pUiContainer->m_lwCtrlSpacer2;
	m_lwCtrlSpacer3 = pUiContainer->m_lwCtrlSpacer3;
	m_lwCtrlSpacer4 = pUiContainer->m_lwCtrlSpacer4;


	m_flatNonBlockDisplay = pUiContainer->m_flatNonBlockDisplay;
	m_flatCtrlDisplay = pUiContainer->m_flatCtrlDisplay;
}

//_________________________________________________________________________________________________

void HierProjSummaryUiPart::updateUi()
{
	ProjSummaryUiPart::updateUi();
	
	m_projDegreeWidg->setValue(project()->getDegree());

	updateIConsistUi();
	updateLwNonBlockUi();
	updateLwCtrlUi();
	updateFlatPropsUi();
}

//_________________________________________________________________________________________________

void HierProjSummaryUiPart::updateIConsistUi()
{
	IConsistProp iConsProp = project()->getIConsistProp();

	//either show the "not verified" label or show the interface-consistency status widgets depending
	//whether the interface consitency property has been verified or not
	bool showIConsistProp = (iConsProp != eIConsNotVerified);
	m_iConsistNotChckLabel->setVisible(!showIConsistProp);	

	//show (or hide) and update the status of the verification widgets
	m_smryIConsistVerifiedLabel->setVisible(showIConsistProp);
	m_smryIConsistDateStampWidg->setVisible(showIConsistProp);
	m_iConsistSpacer1->setVisible(showIConsistProp);
	m_iConsistSpacer2->setVisible(showIConsistProp);
	m_iConsistSpacer3->setVisible(showIConsistProp);
	m_iConsistSpacer4->setVisible(showIConsistProp);
	m_smryIConsistYesWidg->setVisible(showIConsistProp);
	m_smryIConsistNoWidg->setVisible(showIConsistProp);

	if (iConsProp == eIConsYes)
	{
		m_iConsistRadioBtnGroup->check(m_smryIConsistYesWidg);
	}
	else
	{
		m_iConsistRadioBtnGroup->check(m_smryIConsistNoWidg);
	}
	
	//show / hide and update the date of verification
	if (showIConsistProp)
	{
		QString     iConsStamp = QString::fromStdWString(project()->getIConsistStamp());
		QDateTime   iConsDateTime = QDateTime::fromString(iConsStamp);
		m_smryIConsistDateStampWidg->setDateTime(iConsDateTime);
	}

	m_gridLayout->invalidate();
}

//_________________________________________________________________________________________________

void HierProjSummaryUiPart::updateLwNonBlockUi()
{
	LwNonBlockProp lwNonBlockProp = project()->getLwNonBlockProp();

	//either show the "not verified" label or show the level-wise non-blocking status widgets depending
	//whether the level-wise non-blocking property has been verified or not
	bool showLwNonBlockProp = (lwNonBlockProp != eLwNonBlockNotVerified);
	m_lwNonBlockNotChkLabel->setVisible(!showLwNonBlockProp);	
	
	//show (or hide) and update the status of the verification widgets
	m_smryLwNonBlockVerifiedLabel->setVisible(showLwNonBlockProp);
	m_smryLwNonBlockDateStampWidg->setVisible(showLwNonBlockProp);
	m_lwNonblockSpacer1->setVisible(showLwNonBlockProp);
	m_lwNonblockSpacer2->setVisible(showLwNonBlockProp);
	m_lwNonblockSpacer3->setVisible(showLwNonBlockProp);
	m_lwNonblockSpacer4->setVisible(showLwNonBlockProp);
	m_smryLwNonBlockYesWidg->setVisible(showLwNonBlockProp);
	m_smryLwNonBlockNoWidg->setVisible(showLwNonBlockProp);

	if (lwNonBlockProp == eLwNonBlockYes)
	{
		m_lwNonbBlockRadioBtnGroup->check(m_smryLwNonBlockYesWidg);
	}
	else
	{
		m_lwNonbBlockRadioBtnGroup->check(m_smryLwNonBlockNoWidg);;
	}
	
	//show / hide and update the date of verification
	if (showLwNonBlockProp)
	{
		QString     lwNonBlockStamp = QString::fromStdWString(project()->getLwNonBlockStamp());
		QDateTime   lwNonBlockDateTime = QDateTime::fromString(lwNonBlockStamp);
		m_smryLwNonBlockDateStampWidg->setDateTime(lwNonBlockDateTime);
	}

	m_gridLayout->invalidate();
}

//_________________________________________________________________________________________________

void HierProjSummaryUiPart::updateLwCtrlUi()
{
	LwCtrlProp lwCtrlProp = project()->getLwCtrlProp();

	//either show the "not verified" label or show the level-wise controllable status widgets depending
	//whether the level-wise controllable property has been verified or not
	bool showLwCtrlProp = (lwCtrlProp != eLwCtrlNotVerified);
	m_lwCtrlNotChkLabel->setVisible(!showLwCtrlProp);	
	
	//show (or hide) and update the status of the verification widgets
	m_smryLwCtrlYesWidg->setVisible(showLwCtrlProp);
	m_smryLwCtrlNoWidg->setVisible(showLwCtrlProp);
	m_lwCtrlSpacer1->setVisible(showLwCtrlProp);
	m_lwCtrlSpacer2->setVisible(showLwCtrlProp);
	m_lwCtrlSpacer3->setVisible(showLwCtrlProp);
	m_lwCtrlSpacer4->setVisible(showLwCtrlProp);
	m_smryLwCtrlVerifiedLabel->setVisible(showLwCtrlProp);
	m_smryLwCtrlDateStampWidg->setVisible(showLwCtrlProp);

	if (lwCtrlProp == eLwCtrlYes)
	{
		m_lwCtrlRadioBtnGroup->check(m_smryLwCtrlYesWidg);
	}
	else
	{
		m_lwCtrlRadioBtnGroup->check(m_smryLwCtrlNoWidg);;
	}
	
	//update the date of verification
	if (showLwCtrlProp)
	{
		QString     lwCtrlStamp = QString::fromStdWString(project()->getLwCtrlStamp());
		QDateTime   lwCtrlDateTime = QDateTime::fromString(lwCtrlStamp);
		m_smryLwCtrlDateStampWidg->setDateTime(lwCtrlDateTime);
	}

	m_gridLayout->invalidate();
}

//_________________________________________________________________________________________________

void HierProjSummaryUiPart::updateFlatPropsUi()
{	
	switch(project()->getNonBlockingProp())
	{
		case eNonBlockNotVerified:
			m_flatNonBlockDisplay->setText(FLAT_NON_BLOCK_NOT_VERIFIED);
			break;

		case eNonBlockYes:
			m_flatNonBlockDisplay->setText(FLAT_NON_BLOCK_YES);
			break;

		case eNonBlockNo:
			m_flatNonBlockDisplay->setText(FLAT_NON_BLOCK_NO);
			break;

		default:
			assert(false);
			m_flatNonBlockDisplay->setText("");
	}
	
	switch(project()->getControllableProp())
	{
		case eCtrlNotVerified:
			m_flatCtrlDisplay->setText(FLAT_CTRL_NOT_VERIFIED);
			break;

		case eCtrlYes:
			m_flatCtrlDisplay->setText(FLAT_CTRL_YES);
			break;

		case eCtrlNo:
			m_flatCtrlDisplay->setText(FLAT_CTRL_NO);
			break;

		default:
			assert(false);
			m_flatCtrlDisplay->setText("");
	}
}

} //end of namespace DESpot
