/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QMessageBox>
#include <qevent.h>
#include <QInputDialog>
#include <QFileInfo>

//uncomment if which to use cout
#include <iostream>
//#include <cstdio>


// RJL: added for exportBDDhisc -  remove when bddhisc
		//integrated with despot
#include <QFileInfo>
#include "MainForm.h"
// remove to here - RJL

#include "SyncAlgo.h"

#include "HierProjectEditor.h"
#include "CommonDefinitions.h"
#include "EventPoolForm.h"
#include "HierProjectWorkspace.h"
#include "DesHierProject.h"
#include "DesSubsystem.h"
#include "DesInterface.h"
#include "AddLowLevelSubsysDlg.h"
#include "AddInterfaceDlg.h"
#include "Des.h"
#include "HierProjStructureUiPart.h"
#include "AddDesToProjectDlg.h"
#include "HierProjIntegrityAlgo.h"
#include "WaitCursor.h"
#include "LdInterfaceCheckAlgo.h"
#include "OutputUiPart.h"
#include "IConsistAlgo.h"
#include "LwNonBlockingAlgo.h"
#include "LwCtrlAlgo.h"
#include "IConsistAnsAcceptAlgo.h"
#include "LowSubsysIConsistAlgo.h"
#include "HighSubsysNonBlockAlgo.h"
#include "LowSubsysNonBlockAlgo.h"
#include "HighSubsysCtrlAlgo.h"
#include "LowSubsysCtrlAlgo.h"
#include "CheckProjectDlg.h"
#include "HierProjectPropCheck.h"
#include "DesEditor.h"
#include "BddHiscMain.h"
#include "SubsystemLWSynDialog.h"

#include "BddSdMain.h"

#ifdef _WIN32
#include <time.h>
#include <sys/types.h>
#else
#include <sys/time.h>
#endif

#include "HostFileManager.h"
#include "Instantiation.h"
#include "InstantiateTemplate.h"

namespace DESpot
{

HierProjectEditor::HierProjectEditor(const QString& projName, MainForm* pMainForm) : 
		ProjectEditor(pMainForm, eHierProjectEditor),
		m_pCrtSubsys(null),
		m_pCrtInterf(null)
{
	m_pProject = new DesHierProject(projName.toStdWString());

	//by default create the high-level subsystem with the default name
	project()->addHighLevelSubsys(STR_DEFAULT_HIGH_SUBSYS_NAME.toStdWString());

	//create the workspace shown in form
	m_pWorkspace = new HierProjectWorkspace(this, this->project());

	setupConnections();
	
	workspace()->selectDefaults();

	//set form attributes
	setAttribute(Qt::WA_DeleteOnClose);

	updateWindowTitle();
}

//_________________________________________________________________________________________________

HierProjectEditor::HierProjectEditor(DesProject* project, MainForm* pMainForm): 
		ProjectEditor(project, pMainForm, eHierProjectEditor),
		m_pCrtSubsys(null),
		m_pCrtInterf(null)
{
	//create the workspace shown in form
	m_pWorkspace = new HierProjectWorkspace(this, this->project());

	setupConnections();

	workspace()->selectDefaults();

	//set form attributes
	setAttribute(Qt::WA_DeleteOnClose);

	updateWindowTitle();
}

//_________________________________________________________________________________________________

HierProjectEditor::~HierProjectEditor(void)
{
	try
	{	
		
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

DesHierProject* HierProjectEditor::project()
{
	return dynamic_cast<DesHierProject*>(m_pProject);
}

//_________________________________________________________________________________________________

HierProjectWorkspace* HierProjectEditor::workspace()
{
	return dynamic_cast<HierProjectWorkspace*>(m_pWorkspace);
}

//_________________________________________________________________________________________________

void HierProjectEditor::setupConnections()
{
	ProjectEditor::setupConnections();

	connect(&m_pWorkspace->projStructureUiPart(), SIGNAL(onChangedCurrentSubsys(const DesSubsystem* , const DesSubsystem*)), 
			this, SLOT(onChangedCurrentSubsys(const DesSubsystem* , const DesSubsystem*)));

	connect(&m_pWorkspace->projStructureUiPart(), SIGNAL(onChangedCurrentInterf(const DesInterface* , const DesInterface*)), 
			this, SLOT(onChangedCurrentInterf(const DesInterface* , const DesInterface*)));
}

//_________________________________________________________________________________________________

void HierProjectEditor::onChangedCurrentSubsys(const DesSubsystem* pCrtSubsys, const DesSubsystem* pOldCrtSubsys)
{
	try
	{	
		//Remove unused warning in release
		pOldCrtSubsys = pOldCrtSubsys;

		//change the current subsystem. The old current subsystem should match with what the editor
		//had as the current subsystem
		assert(m_pCrtSubsys == pOldCrtSubsys);
		m_pCrtSubsys = pCrtSubsys;
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onChangedCurrentInterf(const DesInterface* pCrtInterf, const DesInterface* pOldCrtInterf)
{
	try
	{	
		//Remove unused warning in release
		pOldCrtInterf = pOldCrtInterf;

		//change the current interface. The old current interface should match with what the editor
		//had as the current interface
		assert(m_pCrtInterf == pOldCrtInterf);
		m_pCrtInterf = pCrtInterf;
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onAddHighLevelSubsystem()
{
	try
	{	
		bool bOk = false;
		QString subsysName = QInputDialog::getText(this, STR_ADD_HIGH_SUBSYS_DLG_TITLE, 
						STR_ADD_HIGH_SUBSYS_DLG_LABEL, QLineEdit::Normal, STR_DEFAULT_HIGH_SUBSYS_NAME, &bOk); 
		if (bOk == false)
			return; //user canceled

		project()->addHighLevelSubsys(subsysName.toStdWString());
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onCheckProjectIntegrity()
{
	try
	{	
		WaitCursor wait(this);
	
		HierProjIntegrityAlgo integAlgo;
		ProjectEditor::onCheckProjectIntegrity(integAlgo);
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onCheckProject()
{
	try
	{	
		CheckProjectDlg checkProjDlg(eHierProject, this);
		if (checkProjDlg.exec() == QDialog::Accepted)
		{
			WaitCursor wait(this);
		
			HierProjectPropCheck projCheckAlgo(*project(), checkProjDlg.checkIncremental());
			
			//configure the algorithm with what properties need to be checked
			projCheckAlgo.checkIntegrity(checkProjDlg.checkValid());
			projCheckAlgo.checkInterfConsist(checkProjDlg.checkIConsist());
			projCheckAlgo.checkLwNonBlock(checkProjDlg.checkLwNonBlocking());
			projCheckAlgo.checkLwCtrl(checkProjDlg.checkLwCtrl());
			
			//run all the checks
			//	projCheckAlgo.runEx(progressInterface());

			time_t tstart;
			time(&tstart);

			projCheckAlgo.runEx(NULL);

			time_t tend;
			time(&tend);

			//show the output
			output().show(projCheckAlgo);
			output().showTime(tend - tstart);
		}
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eProjectPropCheck, L"An error occurred while checking the project's properties", e);
	}
	catch_display_all()
}

//_________________________________________________________________________________________________added by parul

void HierProjectEditor::onAddInterface()
{
	try
	{	
		AddInterfaceDlg addInterfaceDlg(*project(), this);
		if (addInterfaceDlg.exec() == QDialog::Accepted)
		{
			std::wstring interfName = addInterfaceDlg.getInterfName();
			//Modified Parul to map interface to subsystem
			std::wstring subsysName = addInterfaceDlg.getSubsysName();
			
		/*bool bOk = false;
		QString interfName = QInputDialog::getText(this, STR_ADD_INTERF_DLG_TITLE, 
						STR_ADD_INTERF_DLG_LABEL, QLineEdit::Normal, QString(), &bOk); 
		if (bOk == false)
			return; //user canceled
		*/
		project()->addInterface(interfName,subsysName);
	}
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onAddLowLevelSubsystem()
{
	try
	{	
		AddLowLevelSubsysDlg addSubsysDlg(*project(), this);
		if (addSubsysDlg.exec() == QDialog::Accepted)
		{

			//check to see if the user entered a new interface
			std::wstring interfName = addSubsysDlg.getInterfName();
			
			if (addSubsysDlg.isNewInterface())
			{


				if (QMessageBox::question(this, STR_DESPOT, STR_ADD_NEW_INTERFACE, QMessageBox::Yes|QMessageBox::No) == QMessageBox::Yes)
				{
					try
						{	
						AddInterfaceDlg addInterfaceDlg(*project(),interfName, this);
						if (addInterfaceDlg.exec() == QDialog::Accepted)
						{
						std::wstring interfName = addInterfaceDlg.getInterfName();
						std::wstring subsysName = addInterfaceDlg.getSubsysName();
			


						project()->addInterface(interfName,subsysName);
				}
			}
						catch_display_ex()
					//project()->addInterface(interfName);
				}
			}
			

			project()->addLowLevelSubsys(addSubsysDlg.getSubsysName(), interfName);


		}
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onProjCompRename()
{
	try
	{	
		if (m_pCrtSubsys)
		{
			assert(m_pCrtInterf == null);
			
			QString crtSubsysName = QString::fromStdWString(m_pCrtSubsys->getName());
			
			bool bOk = false;
			QString newSubsysName = QInputDialog::getText(this, STR_RENAME_SUBSYS_DLG_TITLE, 
							STR_RENAME_SUBSYS_DLG_LABEL, QLineEdit::Normal, crtSubsysName, &bOk); 		
			if (bOk == false)
				return; //user canceled the operation

			if (newSubsysName.isEmpty())
			{
				QMessageBox::critical(this, STR_DESPOT_ERROR, STR_SUBSYS_RENAME_EMPTY);
			}
			
			if (newSubsysName != crtSubsysName)
			{
				project()->renameSubsystem(*m_pCrtSubsys, newSubsysName.toStdWString());
			}
		}
		else if (m_pCrtInterf)
		{
			assert(m_pCrtSubsys == null);
			
			QString crtInterfName = QString::fromStdWString(m_pCrtInterf->getName());
			
			bool bOk = false;
			QString newInterfName = QInputDialog::getText(this, STR_RENAME_INTERF_DLG_TITLE, 
							STR_RENAME_INTERF_DLG_LABEL, QLineEdit::Normal, crtInterfName, &bOk); 
			if (bOk == false)
				return; //user canceled the operation
			
			if (newInterfName.isEmpty())
			{
				QMessageBox::critical(this, STR_DESPOT_ERROR, STR_INTERF_RENAME_EMPTY);
			}

			if (newInterfName != crtInterfName)
			{
				project()->renameInterface(*m_pCrtInterf, newInterfName.toStdWString());
			}
		}	
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onProjCompDelete()
{
	try
	{	
		//Check if the subsystem has any DES in it or dependencies in the project structure
		//If so warn the user that all DES and dependents will also be removed from the project
		if (m_pCrtSubsys)
		{
			if ((m_pCrtSubsys->getDesCount() > 0) || (m_pCrtSubsys->getDependsCount() > 0))
			{
				if (m_pCrtSubsys->isRoot())
				{
					if (QMessageBox::question(this, STR_DESPOT, STR_DELETE_ROOT_SUBSYS_WARNING, 
						QMessageBox::Yes|QMessageBox::No) == QMessageBox::No)
					{
						return; //the user canceled the operation
					}
				}
				else
				{
					if (QMessageBox::question(this, STR_DESPOT, STR_DELETE_SUBSYS_WARNING, 
						QMessageBox::Yes|QMessageBox::No) == QMessageBox::No)
					{
						return; //the user canceled the operation
					}
				}
			}

			const DesSubsystem* prevCrtSubsys = m_pCrtSubsys;
			project()->deleteSubsystem(m_pCrtSubsys->getName());
			
			//make sure the editor doesn't have the same current subsystem which was just deleted
			if (m_pCrtSubsys == prevCrtSubsys)
			{
				assert(m_pCrtSubsys != prevCrtSubsys); //it should have changed
				m_pCrtSubsys = null;
			}			
		}
		else if (m_pCrtInterf) 
		{
			//Check if the interfacehas any DES in it or dependencies in the project structure
			//If so warn the user that all DES and dependents will also be removed from the project
			if ((m_pCrtInterf->getDesCount() > 0) || project()->getRootSubsys().isDependentOn(*m_pCrtInterf))
			{
				if (QMessageBox::question(this, STR_DESPOT, STR_DELETE_INTERF_WARNING, 
					QMessageBox::Yes|QMessageBox::No) == QMessageBox::No)
				{
					return; //the user canceled the operation
				}
			}

			const DesInterface* prevCrtInterf = m_pCrtInterf;
			project()->deleteInterface(m_pCrtInterf->getName());

			//make sure the editor doesn't have the same current interface which was just deleted
			if (m_pCrtInterf == prevCrtInterf)
			{
				assert(m_pCrtInterf != prevCrtInterf); //it should have changed
				m_pCrtInterf = null;
			}
		}
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onAddDes()
{
//modified by bini
	try
	{	
		AddDesToProjectDlg addDesDlg(*m_pProject, this);
		
		//initialize the dialog approriately depending on what is selected in the
		//project structure widget
		ProjectLevel level;
		if (workspace()->hierProjStructureUiPart().getCurrentLevel(level))
		{
			addDesDlg.setHierLevel(level);
		}

		DesLevel desLevel;
		if (workspace()->projStructureUiPart().getCurrentDesLevel(desLevel))
		{
			//a DES type can be determined from whatever is selected in the 
			//project structure UI part so initialize the dialog to add the same type of DES
			addDesDlg.setDesLevel(desLevel);
		}

		std::wstring containerName;
		if (workspace()->hierProjStructureUiPart().getCurrentProjComp(containerName))
		{
			addDesDlg.setContainerName(containerName);
		}
		
		if (addDesDlg.exec() == QDialog::Accepted)
		{
			Des* pDes = null;
			if (addDesDlg.isNewDes())
			{
				//a new DES must be created with the name given by the user
				DesType desType;
				if(addDesDlg.getHierLevel()==eInterfLevel)
				{
					if(addDesDlg.getDesLevel()==eTemplateDes)
					{
						desType = eInterfaceTemplateDes;
					}
					else
					{
						desType = eInterfaceDes;
					}
				}	
				else
				{
					desType = eSubsystemDes;
				}
				pDes = new Des(addDesDlg.getNewDesName(), desType);			
			}
			else
			{
				pDes = new Des();
				pDes->load(addDesDlg.getDesFileName());
			}

			//add the DES to the project
			project()->addDes(pDes, addDesDlg.getContainerName(), addDesDlg.getDesLevel());
		}
	}
	catch_display_ex()
}
//_________________________________________________________________________________________________
//add by bini
void HierProjectEditor::onInstantiateTemplate()
{
	try
	{
		if(m_pCrtDes&&m_pCrtDes->isTemplate())
		{
			/*if(m_pCrtDes->getIntegrity()!=eIntegYes)
			{
				DesIntegrityAlgo* alg=new DesIntegrityAlgo;
				if(m_pCrtDes->checkIntegrity(*alg)==false)
				{
					throw EX("The template is not validate");
				}
			}*/

			InstantiateTemplate instantiatedlg(*m_pCrtDes,this);
			
			
			if(instantiatedlg.exec()==QDialog::Accepted)
			{
				Des* template_crt=m_pCrtDes;
				Instantiation* inst = new Instantiation(instantiatedlg.getInstantiationName(),instantiatedlg.getLevel(),instantiatedlg.getParameter(),instantiatedlg.getInputType(),template_crt,instantiatedlg.getRangeInput(),instantiatedlg.getTupleInput());
				DesSubsystem* sub=const_cast<DesSubsystem*>(m_pCrtSubsys);
				DesInterface* interf = const_cast<DesInterface*>(m_pCrtInterf);

				
				if(template_crt->getType()==eSubsystemDes)
				{
					project()->instantiatetemplate(template_crt->getName(),inst,sub);
				}
				else if(template_crt->getType()==eInterfaceTemplateDes)
				{
					project()->instantiatetemplate(template_crt->getName(),inst,interf); 
				}
                if(project()->isSuccessful())
				{
				  bool wasSuccessful = false;

				   wasSuccessful = project()->addInstantiation(inst,template_crt);

				   if (wasSuccessful) {
					  // move this here as should
					  // only emit upon successful
					emit onChangedTemplateInstantiate(true);
				   } else {
				     template_crt->setInstantiated(false);
				   }
				}
				
				
		                
				//delete inst;
				//emit onChangedTemplateInstantiate(true);
			}
	
		
		//instantiatedlg.show();
		
		}
	}
	catch_display_ex()


}
//_________________________________________________________________________________________________
//add by bini
void HierProjectEditor::onDeleteInstantiation(bool askConfirm)
{
	if(m_pCrtInst)
	{
            if (askConfirm) {
	        // need to ask for confirmation before deleting
	        std::wstring crtInstName = m_pCrtInst->getName();
		QString delInstWarning = tr("Are you sure you want to remove  instantiation \"%1\" from the project?").arg(QString::fromStdWString(crtInstName));


		//STR_DELETE_DES_FROM_PROJ(QString::fromStdWString(crtDesName));
		if (QMessageBox::question(this, STR_DESPOT,
	            delInstWarning, QMessageBox::Yes|QMessageBox::No)
	            == QMessageBox::No)  {
		  
				return; //the user canceled the operation
		}
            }
		
		InstantiateTemplate::InstantiatedTemplate* result=new InstantiateTemplate::InstantiatedTemplate;
		result=InstantiateTemplate::generateTemplateParameterFromTemplate(*(m_pCrtInst->getParameter()));
		InstantiateTemplate::InstantiatedTemplateItr it=result->begin();
		while(result->end()!=it)
		{
			TemplateNameParser::TemplateParameter* parameter=new TemplateNameParser::TemplateParameter;
			TemplateNameParser::TemplateParameterItr iterator=(&*it)->begin();
			while (iterator != (&*it)->end())
             		{
        	       		parameter->insert(TemplateNameParser::TemplateParameter::value_type(iterator->first,iterator->second));
         		       iterator++;
           		 }
					
			std::wstring name=*(InstantiateTemplate::getNameFromInstantiatedTemplate(m_pCrtInst->getTemplateDes()->getName(),*parameter));
	      /* std::wstring* name=new std::wstring(m_pCrtInst->getTemplateDes()->getName());

		TemplateNameParser::TemplateParameterCItr itr=&*it.begin();
		while(itr!=&*it.end())
		{
			InstantiateTemplate::Replace(*name,L'%'+itr->first+L'%',itr->second);
			itr++;
		}*/
		
			project()->deleteDes(name);
			it++;
	
		}
		//Des* templatedes=m_pCrtInst->getTemplateDes();
		/*switch(m_pCrtInst->getLevel())
		{
		case ePlantDes:
			{
				//Des* curr=m_pCrtInst->getTemplateDes();
				DesProject::DesIteratorPtr itr=m_pProject->createDesIterator(ePlantDes);
				for (itr->first();itr->notDone();itr->next())
				{
					if(itr->currentItem().getInstantiatedTemplate()==m_pCrtInst->getTemplateDes())
					{
						project()->deleteDes(itr->currentItem().getName());
					}
				}
				//m_pCrtInst->getTemplateDes()->setInstantiated(false);
				//curr->setParameter(null);
				//emit onChangedTemplateInstantiate(false);
			}
			break;
		case eSupervisorDes:
			{
				//Des* curr=m_pCrtInst->getTemplateDes();
				DesProject::DesIteratorPtr itr=m_pProject->createDesIterator(eSupervisorDes);
				for (itr->first();itr->notDone();itr->next())
				{
					if(itr->currentItem().getInstantiatedTemplate()==m_pCrtInst->getTemplateDes())
					{
						project()->deleteDes(itr->currentItem().getName());
					}
				}
				//m_pCrtInst->getTemplateDes()->setInstantiated(false);
				//curr->setParameter(null);
				//emit onChangedTemplateInstantiate(false);
			}
			break;
		default:
			assert(false);
		}*/
		m_pCrtInst->getTemplateDes()->setInstantiated(false);
		if(m_pCrtSubsys!=null)
		{
			DesSubsystem* sub=const_cast<DesSubsystem*>(m_pCrtSubsys);
			project()->deleteInstantiation(m_pCrtInst->getName(),*sub);
		}
		else if (m_pCrtInterf!=null)
		{
			DesInterface* interf = const_cast<DesInterface*>(m_pCrtInterf);
			project()->deleteInstantiation(m_pCrtInst->getName(),*interf);
		}
		//delete result;
		
	}

}
//_________________________________________________________________________________________________
//add by bini
void HierProjectEditor::onRegenerateInstantiation()
{
	try
	{
        if (m_pCrtDes)
		{	


			Des* template_crt=m_pCrtDes;
			DesSubsystem* sub=const_cast<DesSubsystem*>(m_pCrtSubsys);
			DesInterface* interf = const_cast<DesInterface*>(m_pCrtInterf);
			if(template_crt->getType()==eSubsystemDes)
			{
				DesSubsystem::InstIteratorPtr itr=sub->createInstIterator();
				for (itr->first();itr->notDone();itr->next())
				{
					if(itr->currentItem().getTemplateDes()==template_crt)
					{

						
						InstantiateTemplate::InstantiatedTemplate* result=new InstantiateTemplate::InstantiatedTemplate;
						result=InstantiateTemplate::generateTemplateParameterFromTemplate(*(itr->currentItem().getParameter()));
						InstantiateTemplate::InstantiatedTemplateItr it=result->begin();
						while(result->end()!=it)
                        			{
						TemplateNameParser::TemplateParameter* parameter=new TemplateNameParser::TemplateParameter;
						TemplateNameParser::TemplateParameterItr iterator=(&*it)->begin();
			 			while (iterator != (&*it)->end())
            					{
               	 				parameter->insert(TemplateNameParser::TemplateParameter::value_type(iterator->first,iterator->second));
                				 iterator++;
            					}
						std::wstring name =*(InstantiateTemplate::getNameFromInstantiatedTemplate(template_crt->getName(),*(parameter)));
						project()->deleteDes(name);
						it++;
						}

					project()->instantiatetemplate(template_crt->getName(),&(itr->currentItem()),sub);
	

				
     // the above call to instantiatetemplate will increase will
     // increase the count of instants incorrectly as this is a regeneration
     // the following call will decrease the count		 
					 template_crt->setInstantiated(false);

					}
				
				}

			}
			
			else
			{
				DesInterface::InstIteratorPtr itr=interf->createInstIterator();
				for (itr->first();itr->notDone();itr->next())
				{
					if(itr->currentItem().getTemplateDes()==template_crt)
					{
						InstantiateTemplate::InstantiatedTemplate* result=new InstantiateTemplate::InstantiatedTemplate;
						result=InstantiateTemplate::generateTemplateParameterFromTemplate(*(itr->currentItem().getParameter()));
						InstantiateTemplate::InstantiatedTemplateItr it=result->begin();
						while(result->end()!=it)
						{
						TemplateNameParser::TemplateParameter* parameter=new TemplateNameParser::TemplateParameter;
						TemplateNameParser::TemplateParameterItr iterator=(&*it)->begin();
			 			while (iterator != (&*it)->end())
            					{
               	 				parameter->insert(TemplateNameParser::TemplateParameter::value_type(iterator->first,iterator->second));
                				 iterator++;
            					}
						std::wstring name =*(InstantiateTemplate::getNameFromInstantiatedTemplate(template_crt->getName(),*(parameter)));
						project()->deleteDes(name);
						it++;
						}
					project()->instantiatetemplate(template_crt->getName(),&(itr->currentItem()),interf);
	
     // the above call to instantiatetemplate will increase will
     // increase the count of instants incorrectly as this is a regeneration
     // the following call will decrease the count		 
					template_crt->setInstantiated(false);
					}
				
				}
			}
			
			//emit onChangedTemplateInstantiate(true);
			
		}
	}
	catch_display_ex()







}
//_________________________________________________________________________________________________
//add by bini
void HierProjectEditor::onEditInst()
{
	try
	{
		Des* template_crt=m_pCrtInst->getTemplateDes();
		if(m_pCrtInst)
		{
			//TemplateNameParser::TemplateParameterItr itr=m_pCrtInst->getParameter()->begin();
			InstantiateTemplate* instantiatedlg = new InstantiateTemplate(*(m_pCrtInst->getTemplateDes()),m_pCrtInst->getLevel(),m_pCrtInst->getParameter(),m_pCrtInst->getName(),m_pCrtInst->getRangeInput(),m_pCrtInst->getTupleInput(),m_pCrtInst->getInputType(),this);
			
			
			if(instantiatedlg->exec()==QDialog::Accepted)
			{
				onDeleteInstantiation(false);
				//Des* template_crt=m_pCrtDes;
                		Instantiation* inst = new Instantiation(instantiatedlg->getInstantiationName(),instantiatedlg->getLevel(),instantiatedlg->getParameter(),instantiatedlg->getInputType(),template_crt,instantiatedlg->getRangeInput(),instantiatedlg->getTupleInput());
				DesSubsystem* sub=const_cast<DesSubsystem*>(m_pCrtSubsys);
				DesInterface* interf=const_cast<DesInterface*>(m_pCrtInterf);
				if(interf==null)
				{
               				project()->instantiatetemplate(template_crt->getName(),inst,sub);
				}
				else
				{	
					project()->instantiatetemplate(template_crt->getName(),inst,interf);
				}
	                        project()->addInstantiation(inst,template_crt);
				//emit onChangedTemplateInstantiate(true);
			}
	
		//delete instantiatedlg;
		
		}
		else
		{

		}
		
	}
	catch_display_ex()






}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunSubsysIConsistTool()
{
	try
	{	
		WaitCursor wait(this);

		if (m_pCrtSubsys == null)
			return;
		if(project()->isBilevel())
		{
		if (m_pCrtSubsys->isRoot())
		{
			IConsistAnsAcceptAlgo ansAcceptAlgo(*project());
			ansAcceptAlgo.provideProgress(NULL);

			time_t tstart;
			time(&tstart);

			project()->checkSubsysIConsistProp(ansAcceptAlgo);

			time_t tend;
			time(&tend);

			output().show(ansAcceptAlgo);
			output().showTime(tend - tstart);
		}
		else
		{
			LowSubsysIConsistAlgo lowSubsysIConsAlgo(*m_pCrtSubsys);
			lowSubsysIConsAlgo.provideProgress(NULL);

			time_t tstart;
			time(&tstart);

			project()->checkSubsysIConsistProp(lowSubsysIConsAlgo);

			time_t tend;
			time(&tend);

			output().show(lowSubsysIConsAlgo);
			output().showTime(tend - tstart);
		}
		}
		else
		{
			if (project()->isValid() == false)
			{
				throw EX("Either project is not valid, or integrity has not yet been checked.");
				return;
			}
			bool nonLeaf = false;
				DesSubsystem::DependIteratorPtr depIt = m_pCrtSubsys->createDependsIterator();
					for(depIt->first(); depIt->notDone(); depIt->next())
					{
						nonLeaf = true;
					}
			if(m_pCrtSubsys->isRoot())
			{
				DesProject* desProj = m_pProject->extractionSystem(m_pCrtSubsys);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				IConsistAnsAcceptAlgo ansAcceptAlgo(*extractedProj);
				ansAcceptAlgo.provideProgress(NULL);

				bool subIConst = extractedProj->checkSubsysIConsistProp(ansAcceptAlgo);
				project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,subIConst);
				output().show(ansAcceptAlgo);
				
	}
			else if(m_pCrtSubsys->isRoot() == false && nonLeaf)
			{
				DesProject* desProjAsRoot = m_pProject->extractionSystem(m_pCrtSubsys);
				DesHierProject* extractedProjAsRoot = dynamic_cast<DesHierProject*>(desProjAsRoot);
				IConsistAnsAcceptAlgo ansAcceptAlgo(*extractedProjAsRoot);
				ansAcceptAlgo.provideProgress(NULL);

				if(extractedProjAsRoot->checkSubsysIConsistProp(ansAcceptAlgo)==false)
				{
				project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,false);
				output().show(ansAcceptAlgo);
				return;
				}

				const DesSubsystem& crtSubsysParent = m_pCrtSubsys->getInterface().getSubsystem();
				DesProject* desProj = m_pProject->extractionSystem(&crtSubsysParent);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				DesSubsystem::DependIteratorPtr lowSubsysIt = extractedProj->getRootSubsys().createDependsIterator();
					for(lowSubsysIt->first(); lowSubsysIt->isDone() == false; lowSubsysIt->next())
					{
						const DesSubsystem*  lowSubsys = lowSubsysIt->currentItem().subsystem;
						if(lowSubsys->getName() == m_pCrtSubsys->getName())
						{
							LowSubsysIConsistAlgo lowSubsysIConsAlgo(*lowSubsys);
							lowSubsysIConsAlgo.provideProgress(NULL);

							if(extractedProj->checkSubsysIConsistProp(lowSubsysIConsAlgo)==false)
							{
								project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,false);
								output().show(lowSubsysIConsAlgo);
								return;
							}
						}

					}
					project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,true);
					output().show(m_pCrtSubsys->getName());
			}
			else if(nonLeaf == false)
			{
				const DesSubsystem& crtSubsysParent = m_pCrtSubsys->getInterface().getSubsystem();
				DesProject* desProj = m_pProject->extractionSystem(&crtSubsysParent);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				DesSubsystem::DependIteratorPtr lowSubsysIt = extractedProj->getRootSubsys().createDependsIterator();
					for(lowSubsysIt->first(); lowSubsysIt->isDone() == false; lowSubsysIt->next())
					{
						const DesSubsystem*  lowSubsys = lowSubsysIt->currentItem().subsystem;
						if(lowSubsys->getName() == m_pCrtSubsys->getName())
						{
							LowSubsysIConsistAlgo lowSubsysIConsAlgo(*lowSubsys);
							lowSubsysIConsAlgo.provideProgress(NULL);

							bool subIConst = extractedProj->checkSubsysIConsistProp(lowSubsysIConsAlgo);
							project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,subIConst);
							output().show(lowSubsysIConsAlgo);
						}

					}
				
			} 
		}

	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eSubsysInterfConsistCheck, L"An error occurred while checking if subsystem is LD interface consistent", e);
	}
	catch_display_all()
	
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunProjIConsistTool()
{
	try
	{	
		WaitCursor wait(this);
		if(project()->isBilevel())
		{
		IConsistAlgo iConsAlgo(*project());	

		iConsAlgo.provideProgress(NULL);

		project()->checkIConsistProp(iConsAlgo);

		output().show(iConsAlgo);
		}
		//this conditions is just to verify that the multi-level project passes integrity test before creating extraction systems on it.
		//It is called againg the iConsAlgo so that it sets the appropriate flags and give appropriate output.
		else if(project()->isBilevel()==false && project()->isValid()==false)
		{
		IConsistAlgo iConsAlgo(*project());	

		iConsAlgo.provideProgress(NULL);

		time_t tstart;
        	time(&tstart);

		project()->checkIConsistProp(iConsAlgo);

		time_t tend;
        	time(&tend);

		output().show(iConsAlgo);
		output().showTime(tend - tstart);
	}
		else
		{
			std::map<std::wstring, bool> subsysIConstMap;
			std::map<std::wstring, bool>::iterator subsysIConstMapIt;
			DesHierProject::SubsysIteratorPtr subsysIt = project()->createSubsysIterator();
			for(subsysIt->first(); subsysIt->notDone(); subsysIt->next())
			{
				bool nonLeaf = false;
				DesSubsystem::DependIteratorPtr depIt = subsysIt->currentItem().createDependsIterator();
					for(depIt->first(); depIt->notDone(); depIt->next())
					{
						nonLeaf = true;
					}
				//call extraction against non-leaf node only
					if(nonLeaf)
					{
						const DesSubsystem& subsysExtraction = subsysIt->currentItem();
						DesProject* desProj = m_pProject->extractionSystem(&subsysExtraction);
						DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
						IConsistAlgo iConsAlgo(*extractedProj);	

						iConsAlgo.provideProgress(NULL);

						bool isIcons = extractedProj->checkIConsistProp(iConsAlgo,subsysIConstMap,project());
						if(isIcons == false)
						{
							DesHierProject::SubsysIteratorPtr subsysMainProjIt = project()->createSubsysIterator();
							for(subsysMainProjIt->first(); subsysMainProjIt->notDone(); subsysMainProjIt->next())
							{
								const DesSubsystem& subMainProj = subsysMainProjIt->currentItem();
								subsysIConstMapIt = subsysIConstMap.find(subMainProj.getName());
								if (subsysIConstMapIt != subsysIConstMap.end())
								{
									bool isNonLeaf = false;
									DesSubsystem::DependIteratorPtr depSubIt = subMainProj.createDependsIterator();
									for(depSubIt->first(); depSubIt->notDone(); depSubIt->next())
									{
										isNonLeaf = true;
									}
									if(subMainProj.isRoot() || isNonLeaf==false)
										subMainProj.setInterfConsist(subsysIConstMapIt->second);
								}

							}
							DesHierProject::InterfIteratorPtr intrefAllIt = project()->createInterfIterator();
							for(intrefAllIt->first(); intrefAllIt->notDone(); intrefAllIt->next())
							{
								const DesInterface& interfMainProj = intrefAllIt->currentItem();
								DesInterface& interfNc= const_cast<DesInterface &>(interfMainProj);
								
								subsysIConstMapIt = subsysIConstMap.find(interfMainProj.getName());
								if (subsysIConstMapIt != subsysIConstMap.end())
									interfNc.setInterfConsist(subsysIConstMapIt->second);
							}
							project()->setIConsistPropMainProj(false);
							
							output().show(iConsAlgo);
							return;
						}
					}
			}
			DesHierProject::SubsysIteratorPtr subsysAllIt = project()->createSubsysIterator();
			for(subsysAllIt->first(); subsysAllIt->notDone(); subsysAllIt->next())
			{
				const DesSubsystem& subsysMainProj = subsysAllIt->currentItem();
				DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
				subsysNc.setInterfConsist(true);
			}
			DesHierProject::InterfIteratorPtr intrefAllIt = project()->createInterfIterator();
			for(intrefAllIt->first(); intrefAllIt->notDone(); intrefAllIt->next())
			{
				const DesInterface& interfMainProj = intrefAllIt->currentItem();
				DesInterface& interfNc= const_cast<DesInterface &>(interfMainProj);
				interfNc.setInterfConsist(true);
			}
			project()->setIConsistPropMainProj(true);
			output().show(eLwIConst);
		}
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eInterfConsistCheck, L"An error occurred while checking if project is LD interface consistent", e);
	}
	catch_display_all()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunContextSyncProductTool()
{
	try
	{	
		WaitCursor wait(this);
		
		DesProject::DesIteratorPtr desIterator;

		//determine which DES will be part of the context sync product depending what the user selected
		if (workspace()->hierProjStructureUiPart().isProjectSelected())
		{
			desIterator = m_pProject->createDesIterator();
		}
		else if (m_pCrtInterf != null)
		{
			if (m_pCrtInterf->getDesCount() < 2)
			{
				QMessageBox::information(this, "DESpot", STR_INTERF_SYNC_ERROR);
				return;
			}
			
			desIterator = m_pCrtInterf->createDesIterator();
		}
		else if (m_pCrtSubsys != null)
		{
			//figure out if the user has selected just the plant, the supervisor or the entire subsystem
			if (workspace()->hierProjStructureUiPart().isSupervisorSelected())
			{
				if (m_pCrtSubsys->getSupDesCount() < 2)
				{
					QMessageBox::information(this, "DESpot", STR_SUP_SYNC_ERROR);
					return;
				}
				desIterator = m_pCrtSubsys->createDesIterator(eSupervisorDes);
			}
			else if (workspace()->hierProjStructureUiPart().isPlantSelected())
			{
				if (m_pCrtSubsys->getPlantDesCount() < 2)
				{
					QMessageBox::information(this, "DESpot", STR_PLANT_SYNC_ERROR);
					return;
				}

				desIterator = m_pCrtSubsys->createDesIterator(ePlantDes);
			}
//add by bini
			else if (workspace()->hierProjStructureUiPart().isTemplateSelected())
			{
				if (m_pCrtSubsys->getTemplateDesCount() < 2)
				{
					QMessageBox::information(this, "DESpot", STR_TEMPLATE_SYNC_ERROR);
					return;
				}

				desIterator = m_pCrtSubsys->createDesIterator(eTemplateDes);
			}
			else
			{
				if (m_pCrtSubsys->getDesCount() < 2)
				{
					QMessageBox::information(this, "DESpot", STR_SUBSYS_SYNC_ERROR);
					return;
				}

				desIterator = m_pCrtSubsys->createDesIterator();
			}
		}
		else
		{
			//check to see if a supervisor or plant is selected	because in the Level View it is possible
			//to select Plant / Supervisor without the subsystem being actually selected
			if (workspace()->hierProjStructureUiPart().isSupervisorSelected())
			{
				std::wstring subsysName; 
				if (workspace()->hierProjStructureUiPart().getCurrentProjComp(subsysName))
				{
					const DesHierProject& project = *(this->project());
					const DesSubsystem& selectedSubsys = project.getSubsystem(subsysName);
					
					if (selectedSubsys.getSupDesCount() < 2)
					{
						QMessageBox::information(this, "DESpot", STR_SUP_SYNC_ERROR);
						return;
					}
					
					desIterator = selectedSubsys.createDesIterator(eSupervisorDes);
				}
			}
			else if (workspace()->hierProjStructureUiPart().isPlantSelected())
			{
				std::wstring subsysName; 
				if (workspace()->hierProjStructureUiPart().getCurrentProjComp(subsysName))
				{
					const DesHierProject& project = *(this->project());
					const DesSubsystem& selectedSubsys = project.getSubsystem(subsysName);
					
					if (selectedSubsys.getPlantDesCount() < 2)
					{
						QMessageBox::information(this, "DESpot", STR_PLANT_SYNC_ERROR);
						return;
					}
					
					desIterator = selectedSubsys.createDesIterator(ePlantDes);
				}
			}
//add by bini
			else if (workspace()->hierProjStructureUiPart().isTemplateSelected())
			{
				std::wstring subsysName; 
				if (workspace()->hierProjStructureUiPart().getCurrentProjComp(subsysName))
				{
					const DesHierProject& project = *(this->project());
					const DesSubsystem& selectedSubsys = project.getSubsystem(subsysName);
					
					if (selectedSubsys.getTemplateDesCount() < 2)
					{
						QMessageBox::information(this, "DESpot", STR_TEMPLATE_SYNC_ERROR);
						return;
					}
					
					desIterator = selectedSubsys.createDesIterator(eTemplateDes);
				}
			}

		 	/*else if (workspace()->hierProjStructureUiPart().isInstantiationSelected())
			{
				std::wstring subsysName; 
				if (workspace()->hierProjStructureUiPart().getCurrentProjComp(subsysName))
				{
					const DesHierProject& project = *(this->project());
					const DesSubsystem& selectedSubsys = project.getSubsystem(subsysName);
					
					if (selectedSubsys.getInstantiationCount() < 2)
					{
						QMessageBox::information(this, "DESpot", STR_INSTANTIATION_SYNC_ERROR);
						return;
					}
					
					InstIterator = selectedSubsys.createInstIterator();
				}
			}*/

			else
			{
				QMessageBox::information(this, "DESpot", STR_COMPONENT_SYNC_ERROR);
				return;	
			}
		}
		
		SyncAlgo syncAlgo(desIterator);
		if (syncAlgo.runEx(progressInterface()))
		{
			Des* resultDes = syncAlgo.returnResult();

			//create an editor that will load the DES from the selected file
			DesEditor* pDesEditor = new DesEditor(resultDes, mainForm());

			//display the DES to the user
			pDesEditor->open();
		}
	}
	catch_display_ex()}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunCheckInterfTool()
{
	try
	{	
		WaitCursor wait(this);

		if (m_pCrtInterf)
		{
			LdInterfaceCheckAlgo ldInterfCheckAlgo(*m_pCrtInterf);
			ldInterfCheckAlgo.provideProgress(NULL);

			time_t tstart;
			time(&tstart);

			project()->checkInterfIConsistProp(ldInterfCheckAlgo);

			time_t tend;
			time(&tend);

			output().show(ldInterfCheckAlgo);
			output().showTime(tend - tstart);
		}
	
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eLdInterfCheck, L"An error occurred while checking if selected interface is an LD interface", e);
	}
	catch_display_all()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunSubsysNonblockingTool()
{
	try
	{	
		WaitCursor wait(this);

		if (m_pCrtSubsys == null)
			return;
		if(project()->isBilevel())
		{
		if (m_pCrtSubsys->isRoot())
		{
			HighSubsysNonBlockAlgo hSubsysNonBlockAlgo(*project());
			hSubsysNonBlockAlgo.provideProgress(NULL);			
			
			time_t tstart;
			time(&tstart);

			project()->checkSubsysNonBlockProp(hSubsysNonBlockAlgo);

			time_t tend;
			time(&tend);

			output().show(hSubsysNonBlockAlgo);
			output().showTime(tend - tstart);
		}
		else
		{
			LowSubsysNonBlockAlgo lowSubsysNonBlockAlgo(*m_pCrtSubsys);
			lowSubsysNonBlockAlgo.provideProgress(NULL);

			time_t tstart;
			time(&tstart);

			project()->checkSubsysNonBlockProp(lowSubsysNonBlockAlgo);

			time_t tend;
			time(&tend);

			output().show(lowSubsysNonBlockAlgo);
			output().showTime(tend - tstart);
		}
		}
		else
		{
			if (project()->isValid() == false)
			{
				throw EX("Either project is not valid, or integrity has not yet been checked.");
				return;
			}
			bool nonLeaf = false;
			DesSubsystem::DependIteratorPtr depIt = m_pCrtSubsys->createDependsIterator();
			for(depIt->first(); depIt->notDone(); depIt->next())
			{
				nonLeaf = true;
			}
			if(nonLeaf)
			{
				DesProject* desProj = m_pProject->extractionSystem(m_pCrtSubsys);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				HighSubsysNonBlockAlgo hSubsysNonBlockAlgo(*extractedProj);
				hSubsysNonBlockAlgo.provideProgress(NULL);			

				bool subNonBlock = extractedProj->checkSubsysNonBlockProp(hSubsysNonBlockAlgo);


				project()->setSubsysNonBlockPropMainProj(*m_pCrtSubsys,subNonBlock);

				output().show(hSubsysNonBlockAlgo);
	}
			else
			{
				const DesSubsystem& crtSubsysParent = m_pCrtSubsys->getInterface().getSubsystem();
				DesProject* desProj = m_pProject->extractionSystem(&crtSubsysParent);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				DesSubsystem::DependIteratorPtr lowSubsysIt = extractedProj->getRootSubsys().createDependsIterator();
				for(lowSubsysIt->first(); lowSubsysIt->isDone() == false; lowSubsysIt->next())
				{
					const DesSubsystem*  lowSubsys = lowSubsysIt->currentItem().subsystem;
					if(lowSubsys->getName() == m_pCrtSubsys->getName())
					{
						LowSubsysNonBlockAlgo lowSubsysNonBlockAlgo(*lowSubsys);
						lowSubsysNonBlockAlgo.provideProgress(NULL);

						bool subNonBlock = extractedProj->checkSubsysNonBlockProp(lowSubsysNonBlockAlgo);

						project()->setSubsysNonBlockPropMainProj(*m_pCrtSubsys,subNonBlock);
						output().show(lowSubsysNonBlockAlgo);
					}
				}
			}
		}
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eSubsysNonblockingCheck, L"An error occurred while checking if selected subsystem is level-wise nonblocking", e);
	}
	catch_display_all()

}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunLevelWiseNonblockingTool()
{
	try
	{	
		WaitCursor wait(this);

		if(project()->isBilevel())
		{
		
		LwNonBlockingAlgo lwNonBlockAlgo(*project());	

		lwNonBlockAlgo.provideProgress(NULL);

		time_t tstart;
        	time(&tstart);

		project()->checkLwNonBlockProp(lwNonBlockAlgo);

		time_t tend;
        	time(&tend);

		output().show(lwNonBlockAlgo);
		output().showTime(tend - tstart);
	}
		//this conditions is just to verify that the multi-level project passes integrity test before creating extraction systems on it.
		//It is called against the lwNonBlocAlgo so that it sets the appropriate flags and give appropriate output.
		else if(project()->isBilevel()==false && project()->isValid()==false)
		{
		LwNonBlockingAlgo lwNonBlockAlgo(*project());	

		lwNonBlockAlgo.provideProgress(NULL);

		project()->checkLwNonBlockProp(lwNonBlockAlgo);

		output().show(lwNonBlockAlgo);
		}
		else
		{
			std::map<std::wstring, bool> subsysNonBlockMap;
			std::map<std::wstring, bool>::iterator subsysNonBlockMapIt;
			DesHierProject::SubsysIteratorPtr subsysIt = project()->createSubsysIterator();
			for(subsysIt->first(); subsysIt->notDone(); subsysIt->next())
			{
				bool nonLeaf = false;
				DesSubsystem::DependIteratorPtr depIt = subsysIt->currentItem().createDependsIterator();
					for(depIt->first(); depIt->notDone(); depIt->next())
					{
						nonLeaf = true;
					}
				//call extraction against non-leaf node only
					if(nonLeaf)
					{
						const DesSubsystem& subsysExtraction = subsysIt->currentItem();
						DesProject* desProj = project()->extractionSystem(&subsysExtraction);
						DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
						LwNonBlockingAlgo lwNonBlockAlgo(*extractedProj);	

						lwNonBlockAlgo.provideProgress(NULL);

						bool isNonBloc = extractedProj->checkLwNonBlockProp(lwNonBlockAlgo,subsysNonBlockMap);

						if(isNonBloc==false)
						{
							DesHierProject::SubsysIteratorPtr subsysNonBlockIt = project()->createSubsysIterator();
							for(subsysNonBlockIt->first(); subsysNonBlockIt->notDone(); subsysNonBlockIt->next())
							{
								subsysNonBlockMapIt = subsysNonBlockMap.find(subsysNonBlockIt->currentItem().getName());
								if (subsysNonBlockMapIt != subsysNonBlockMap.end())
								{
									subsysNonBlockIt->currentItem().setNonBlocking(subsysNonBlockMapIt->second);
								}
								
							}
							project()->setLwNonBlockPropMainProj(false);
							output().show(lwNonBlockAlgo);
							return;
						}
					}
			}
			DesHierProject::SubsysIteratorPtr subsysIt1 = project()->createSubsysIterator();
			for(subsysIt1->first(); subsysIt1->notDone(); subsysIt1->next())
			{
				const DesSubsystem& subsysMainProj = subsysIt1->currentItem();
				DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
				subsysNc.setNonBlocking(true);
			}
			project()->setLwNonBlockPropMainProj(true);
			output().show(eLwNonBlock);
						
		}
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eLwNonblockingCheck, L"An error occurred while checking if project is level-wise nonblocking", e);
	}
	catch_display_all()
}

//_________________________________________________________________________________________________
void HierProjectEditor::onRunSubsysSimulationActTool()
{		
		WaitCursor wait(this);
		if (m_pCrtSubsys == null)
			return;
		map<std::wstring,short> myNull;
		if (m_pCrtSubsys->isRoot())
		{
			DESpot::DummyProject m_dummyproj(m_pCrtSubsys,(DesHierProject*)m_pProject,myNull);
			m_pProject->setSubsysDummyProject( m_dummyproj.GetDummyProject());
		}
		else if(m_pCrtSubsys->getLevel() > 0)
		{
			DESpot::DummyProject m_dummyproj(m_pCrtSubsys,myNull,(DesHierProject*)m_pProject);
			m_pProject->setSubsysDummyProject( m_dummyproj.GetDummyProject());
		}

		try
	{
		
		SimConfig* pSimConfig = new SimConfig(m_pProject->getSubsysDummyProject(), m_pMainForm, this,DespotForm::eSimConfig);
		//SimConfig* pSimConfig = new SimConfig(m_pProject, this, DespotForm::eSimConfig);

		pSimConfig->open();
		pSimConfig->initSimConfig();
	}
	catch_display_ex()
	
}

//=================================================================================================

void HierProjectEditor::onRunSubsysCtrlTool()
{
	try
	{	
		WaitCursor wait(this);

		if (m_pCrtSubsys == null)
			return;
		if(project()->isBilevel())
		{
		if (m_pCrtSubsys->isRoot())
		{
			HighSubsysCtrlAlgo hSubsysCtrlAlgo(*project());
			hSubsysCtrlAlgo.provideProgress(NULL);
			
			time_t tstart;
			time(&tstart);

			project()->checkSubsysLwCtrlProp(hSubsysCtrlAlgo);

			time_t tend;
			time(&tend);

			output().show(hSubsysCtrlAlgo);
			output().showTime(tend - tstart);
		}
		else
		{
			LowSubsysCtrlAlgo lowSubsysCtrlAlgo(*m_pCrtSubsys);
			lowSubsysCtrlAlgo.provideProgress(NULL);
			
			time_t tstart;
			time(&tstart);

			project()->checkSubsysLwCtrlProp(lowSubsysCtrlAlgo);

			time_t tend;
			time(&tend);

			output().show(lowSubsysCtrlAlgo);
			output().showTime(tend - tstart);
		}
		}
		else
		{
			if (project()->isValid() == false)
			{
				throw EX("Either project is not valid, or integrity has not yet been checked.");
				return;
			}
			if(m_pCrtSubsys->isRoot())
			{
				DesProject* desProj = m_pProject->extractionSystem(m_pCrtSubsys);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				HighSubsysCtrlAlgo hSubsysCtrlAlgo(*extractedProj);
				hSubsysCtrlAlgo.provideProgress(NULL);

				bool subContrl = extractedProj->checkSubsysLwCtrlProp(hSubsysCtrlAlgo);
				
				project()->setSubsysCtrlPropMainProj(*m_pCrtSubsys,subContrl);
				output().show(hSubsysCtrlAlgo);
	}
			else
			{
				const DesSubsystem& crtSubsysParent = m_pCrtSubsys->getInterface().getSubsystem();
				DesProject* desProj = m_pProject->extractionSystem(&crtSubsysParent);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				DesSubsystem::DependIteratorPtr lowSubsysIt = extractedProj->getRootSubsys().createDependsIterator();
				for(lowSubsysIt->first(); lowSubsysIt->isDone() == false; lowSubsysIt->next())
				{
					const DesSubsystem*  lowSubsys = lowSubsysIt->currentItem().subsystem;
					if(lowSubsys->getName() == m_pCrtSubsys->getName())
					{
						LowSubsysCtrlAlgo lowSubsysCtrlAlgo(*lowSubsys);
						lowSubsysCtrlAlgo.provideProgress(NULL);

						bool subContrl=extractedProj->checkSubsysLwCtrlProp(lowSubsysCtrlAlgo);
				
						project()->setSubsysCtrlPropMainProj(*m_pCrtSubsys,subContrl);
						output().show(lowSubsysCtrlAlgo);


					}

				}
			}
		}
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eSubsysCtrlCheck, L"An error occurred while checking if selected subsystem is level-wise controllable", e);
	}
	catch_display_all()
}
//_________________________________________________________________________________________________

void HierProjectEditor::onRunLevelWiseCtrlTool()
{
	WaitCursor wait(this);

	try
	{	
		if(project()->isBilevel())
		{

		LwCtrlAlgo lwCtrlAlgo(*project());	

		lwCtrlAlgo.provideProgress(NULL);

		project()->checkLwCtrlProp(lwCtrlAlgo);

		output().show(lwCtrlAlgo);
		}
		//this conditions is just to verify that the multi-level project passes integrity test before creating extraction systems on it.
		//It is called againg the loCtrlAlgo so that it sets the appropriate flags and give appropriate output.
		else if(project()->isBilevel()==false && project()->isValid()==false)
		{
		LwCtrlAlgo lwCtrlAlgo(*project());	

		lwCtrlAlgo.provideProgress(NULL);

		time_t tstart;
        	time(&tstart);

		project()->checkLwCtrlProp(lwCtrlAlgo);

		time_t tend;
        	time(&tend);

		output().show(lwCtrlAlgo);
		output().showTime(tend - tstart);
	}
		else
		{
			std::map<std::wstring, bool> subsysCtrlMap;
			std::map<std::wstring, bool>::iterator subsysCtrlMapIt;
			DesHierProject::SubsysIteratorPtr subsysIt = project()->createSubsysIterator();
			for(subsysIt->first(); subsysIt->notDone(); subsysIt->next())
			{
				bool nonLeaf = false;
				DesSubsystem::DependIteratorPtr depIt = subsysIt->currentItem().createDependsIterator();
					for(depIt->first(); depIt->notDone(); depIt->next())
					{
						nonLeaf = true;
					}
				//call extraction against non-leaf node only
					if(nonLeaf)
					{
						const DesSubsystem& subsysExtraction = subsysIt->currentItem();
						DesProject* desProj = project()->extractionSystem(&subsysExtraction);
						DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
						LwCtrlAlgo lwCtrlAlgo(*extractedProj);	

						lwCtrlAlgo.provideProgress(NULL);

						extractedProj->checkLwCtrlProp(lwCtrlAlgo,subsysCtrlMap);

						if(extractedProj->isLwControllable()==false)
						{
							DesHierProject::SubsysIteratorPtr subsysNonBlockIt = project()->createSubsysIterator();
							for(subsysNonBlockIt->first(); subsysNonBlockIt->notDone(); subsysNonBlockIt->next())
							{
								subsysCtrlMapIt = subsysCtrlMap.find(subsysNonBlockIt->currentItem().getName());
								if (subsysCtrlMapIt != subsysCtrlMap.end())
								{
									subsysNonBlockIt->currentItem().setControllable(subsysCtrlMapIt->second);
								}
								
							}
							project()->setLwCtrlPropMainProj(false);
							output().show(lwCtrlAlgo);
							return;
						}
					}
			}
			DesHierProject::SubsysIteratorPtr subsysIt1 = project()->createSubsysIterator();
			for(subsysIt1->first(); subsysIt1->notDone(); subsysIt1->next())
			{
				const DesSubsystem& subsysMainProj = subsysIt1->currentItem();
				DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
				subsysNc.setControllable(true);
			}
			project()->setLwCtrlPropMainProj(true);
			output().show(eLwCtrl);
		}
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eLwCtrlCheck, L"An error occurred while checking if project is level-wise controllable", e);
	}
	catch_display_all()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunLevelWiseSynthesisTool()
{
	try
	{		
		QMessageBox::information(this, "DESpot","Feature not implemented yet.");
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onDisplayEventPool()
{
	try
	{	
		if (m_pEventPoolForm == null)
		{
			m_pEventPoolForm = new EventPoolForm(m_pMainForm, this);
		}
		
		m_pEventPoolForm->open();
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

//Added by Adam for bddExport   remove when bddhisc
// integrated with despot  (see other places where changes made and
// remove as well). See svn revision 220 for details. 218 as well.
void HierProjectEditor::onExportToBDDhisc()
{
	try
	{
	  attemptExportToBDDhisc();
	}
	catch_display_xml_ex()
	catch_display_ex()
}

// remove to here - Adam

//_________________________________________________________________________________________________

// added by RJL - remove when bddhisc
// integrated with despot 
bool HierProjectEditor::attemptExportToBDDhisc()
{


  /*if (!m_pProject->isValid()) 
    {
       throw EX("Project integrity test must pass before exporting allowed.");
    }*/


  QString warning = "WARNING: exporting to BDDhisc format will create\
  a number of files (*.prj for projects, *.sub for subsystems, and\
  *.hsc for DES).  If any file already exists, it will be overwritten\
  without warning.\n\nDo you want to continue?"; 


  if (QMessageBox::question(this, STR_DESPOT_WARNING, warning, QMessageBox::Yes|QMessageBox::No) == QMessageBox::No)
    {
			return false;
    }


	QString absoluteFileName = m_pProject->isNew()? QString::fromStdWString(m_pProject->getName()) : QString::fromStdWString(m_pProject->getFileName()); 


        if (absoluteFileName.endsWith(".desp",Qt::CaseInsensitive)) 
	  {
	    absoluteFileName.replace((absoluteFileName.length()-4), 4,"prj");
	  }

      
	if (MainForm::getSaveFileName(this, tr("Export to BDDhisc format"), tr("BDDhisc Project Files (*.prj)"), absoluteFileName) == false)
	{
		//user canceled the save as
		return false;
	}

	//getSaveFileName  is adding the despot extension, so we need
        // to remove that
        if (absoluteFileName.endsWith(".desp",Qt::CaseInsensitive)) 
	  {
	    absoluteFileName.remove((absoluteFileName.length()-5), 5);
	  }

	// we now need to check to make sure name ends in ".prj"
        if (!absoluteFileName.endsWith(".prj",Qt::CaseInsensitive)) 
	  {
	    absoluteFileName += ".prj";
	  }


	NameValidator fileNameValidator(new AlphaNumValidator(new WordSepValidator(new DotValidator())));
	std::wstring fileName = QFileInfo(absoluteFileName).fileName().toStdWString();
	if (fileNameValidator.validate(fileName) == false)							  
	{
		std::wstring message = L"Invalid project file name (";
		message += fileName;
		message += L"). Use an alpha-numeric string (a-z;A-Z;0-9;.-_)";
		throw message;
	}

	m_pProject->exportToBDDhisc(absoluteFileName.toStdWString());

	return true;
}

// remove to here - RJL

#ifdef __ENABLE_BDD__

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddMultiCtrlTool()
{
  try
    {

	  //		QMessageBox::information(this, "DESpot","Feature not implemented yet.");

      WaitCursor wait(this);	

      int tmp;
      BDDSD::SD_CtrlChkInfo  checkInfo("Project passes Untimed Controllability Check");
     
      tmp = BddSdCheckCtrl(*m_pProject, checkInfo);
      
      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      project()->procBddCtrlProp(checkInfo);

      output().show(checkInfo);
      
    }
  catch_display_ex()


}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddNonBlockingTool()
{
  try
    {
      //		QMessageBox::information(this, "DESpot","Feature not implemented yet.");
      
      WaitCursor wait(this);	
      
      int tmp;
      BDDSD::SD_NBChkInfo  checkInfo("Project passes Nonblocking Check");
      
      tmp = BddSdCheckNB(*m_pProject, checkInfo);

      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      project()->procBddNonBlockProp(checkInfo);
      
      output().show(checkInfo);

    }
  catch_display_ex()

}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddCheckInterfTool()
{
  try
    {	

      WaitCursor wait(this);	
	
      if (m_pCrtInterf == null)
	{
	  // no interface selected
	  return;
	}   

      if (!m_pProject->isValid()) 
	{
	  throw EX("Project integrity test must pass before running BDD algorithms.");
	}

      // need to determine which subsystem belongs to interface
      QString intfName = QString::fromStdWString(m_pCrtInterf->getName());
      QString subSysName = "";

      BDDHISC::Hisc_LDIntfChkInfo checkInfo("Interface '" + intfName +  
					    "' is an LD interface.",
					    intfName); 

	   DESpot::DesHierProject* hierProject = null;
	   DesProject* desProj = null;
	  if(project()->isBilevel())
	  {
      hierProject = dynamic_cast<DESpot::DesHierProject*>(m_pProject);
	  }
	  else
	  {
		  const DesSubsystem* subsysAbove = &m_pCrtInterf->getSubsystem();
		  desProj = m_pProject->extractionSystem(subsysAbove);
		  DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
		  hierProject = dynamic_cast<DESpot::DesHierProject*>(desProj);
	  }

      DesHierProject::SubsysIteratorPtr subsysIt = hierProject->createSubsysIterator();
      for(subsysIt->first(); subsysIt->notDone(); subsysIt->next())
	{
	  const DesSubsystem& lowSubsys = subsysIt->currentItem();
	  
	  if ((lowSubsys.isRoot() == false) && (lowSubsys.implementsInterface()))
	    {
	      const DESpot::DesInterface& interf =  lowSubsys.getInterface();

	      if (interf.getName() == m_pCrtInterf->getName())
		{
		  subSysName = QString::fromStdWString(lowSubsys.getName());
		  //removed by zain
		  // remove spaces from name
		 /* while (subSysName.contains(" "))
		    {
		      subSysName.remove(' ');
		    }
		  break;
		  */
		}
	    }
	}

      if (subSysName == "")
	{
	  throw EX("Bddhisc requires interfaces to be associated with \
a subsystems");
	}

      int tmp;
      QString succMessage = "";
      bool isHigh = false;
      
	  if(project()->isBilevel())
	  {
      tmp = BDDHISC::BddHiscCheckIntf(*m_pProject, subSysName,
					    isHigh, checkInfo); 
	  }
	  else
	  {
		   tmp = BDDHISC::BddHiscCheckIntf(*desProj, subSysName,
					    isHigh, checkInfo); 
	  }

      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      project()->procBddInterfProp(checkInfo, *m_pCrtInterf);

      output().show(checkInfo);

    }
    catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddCheckAllTool()
{
  try
    {	

      WaitCursor wait(this);	

      int tmp;

      BDDHISC::Hisc_ChkInfo checkInfo("Project is LD interface consistent, LD level-wise nonblocking and LD level-wise controllable.");

		if(project()->isBilevel())
		{
      tmp = BDDHISC::BddHiscCheckHISCAll(*m_pProject, checkInfo);

      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      if (checkInfo.m_chkPassed)
	{
	  // all passed so update all statuses.
	  project()->procBddLwNonBlockProp(checkInfo);
	  project()->procBddLwCtrlProp(checkInfo);
	  project()->procBddIConsistProp(checkInfo);

	  // now need to send output to various tabs
	  BDDHISC::Hisc_LWNBChkInfo checkInfoNB("Project is LD level-wise nonblocking.");
	  checkInfoNB.m_chkPassed = true;
	  output().show(checkInfoNB, OutputUiPart::eSetLastOutput, false /*no popup */);

	  BDDHISC::Hisc_LWContChkInfo checkInfoCtrl("Project is LD level-wise controllable."); 
	  checkInfoCtrl.m_chkPassed = true;
	  output().show(checkInfoCtrl, OutputUiPart::eAppendLastOutput, false);

	  BDDHISC::Hisc_IConsisChkInfo checkInfoIC("Project is LD interface consistent, LD level-wise nonblocking and LD level-wise controllable.");
	  checkInfoIC.m_chkPassed = true;
	  checkInfoIC.m_succStr = checkInfo.m_succStr;
	  output().show(checkInfoIC, OutputUiPart::eAppendLastOutput, true);
	}
      else
	{
	  //  can only update and output for the failed property
	  if (checkInfo.m_LDNBChkFail)
	    {
	      project()->procBddLwNonBlockProp(checkInfo);
	      BDDHISC::Hisc_LWNBChkInfo checkInfoNB("Project is LD level-wise nonblocking.");
	      checkInfoNB.m_chkPassed = false;
	      checkInfoNB.m_errStr = checkInfo.m_errStr;
		  checkInfoNB.CE_tuplemap=checkInfo.CE_tuplemap;
		 // checkInfoNB.setErrorTuple(checkInfo.getErrorTuple()->size(),*checkInfo.getErrorTuple());
		  checkInfoNB.setErrorSubSystemName(checkInfo.getErrorSubsystemName());
		  checkInfoNB.setIFailureType(checkInfo.getIFailureType());
	      output().show(checkInfoNB);
	    }
	  else if (checkInfo.m_LDCtrlChkFail)
	    {
	      project()->procBddLwCtrlProp(checkInfo);
	      BDDHISC::Hisc_LWContChkInfo checkInfoCtrl("Project is LD level-wise controllable."); 
	      checkInfoCtrl.m_chkPassed = false;
	      checkInfoCtrl.m_errStr = checkInfo.m_errStr;
		  checkInfoCtrl.CE_tuplemap=checkInfo.CE_tuplemap;
		  //checkInfoCtrl.setErrorTuple(checkInfo.getErrorTuple()->size(),*checkInfo.getErrorTuple());
		  checkInfoCtrl.setErrorSubSystemName(checkInfo.getErrorSubsystemName());
		  checkInfoCtrl.setIFailureType(checkInfo.getIFailureType());
	      output().show(checkInfoCtrl);
	    }
	  else if (checkInfo.m_iConsisChkFail)
	    {
	      project()->procBddIConsistProp(checkInfo);
	      BDDHISC::Hisc_IConsisChkInfo checkInfoIC("Project is LD interface consistent.");
	      checkInfoIC.m_chkPassed = false;
	      checkInfoIC.m_errStr = checkInfo.m_errStr;
		  checkInfoIC.CE_tuplemap=checkInfo.CE_tuplemap;
		 // checkInfoIC.setErrorTuple(checkInfo.getErrorTuple()->size(),*checkInfo.getErrorTuple());
		  checkInfoIC.setErrorSubSystemName(checkInfo.getErrorSubsystemName());
		  checkInfoIC.setIFailureType(checkInfo.getIFailureType());
	      output().show(checkInfoIC);
	    }
	}
		
    }
		else if(project()->isBilevel()==false && project()->isValid()==false)
		{
			throw EX("Project integrity test must pass before running BDD algorithms.");
				return;
		}
		else //this else section creates extractions systems and run all algo on them
		{
			DesHierProject::SubsysIteratorPtr subsysIt = project()->createSubsysIterator();
		  for(subsysIt->first(); subsysIt->notDone(); subsysIt->next())
			{
				bool nonLeaf = false;
				DesSubsystem::DependIteratorPtr depIt = subsysIt->currentItem().createDependsIterator();
					for(depIt->first(); depIt->notDone(); depIt->next())
					{
						nonLeaf = true;
					}
				//call extraction against non-leaf node only
					if(nonLeaf)
					{
						const DesSubsystem& subsysExtraction = subsysIt->currentItem();
						DesProject* desProj = project()->extractionSystem(&subsysExtraction);
			tmp = BDDHISC::BddHiscCheckHISCAll(*desProj, checkInfo);
			//  can only update and output for the failed property
			if (checkInfo.m_chkPassed == false) 
			{
			if (checkInfo.m_LDNBChkFail)
			{
				project()->setLwNonBlockPropMainProj(false);
				BDDHISC::Hisc_LWNBChkInfo checkInfoNB("Project is LD level-wise nonblocking.");
				checkInfoNB.m_chkPassed = false;
				checkInfoNB.m_errStr = checkInfo.m_errStr;
				output().show(checkInfoNB);
				return;
			}
			else if (checkInfo.m_LDCtrlChkFail)
			{
				project()->setLwCtrlPropMainProj(false);
				BDDHISC::Hisc_LWContChkInfo checkInfoCtrl("Project is LD level-wise controllable."); 
				checkInfoCtrl.m_chkPassed = false;
				checkInfoCtrl.m_errStr = checkInfo.m_errStr;
				output().show(checkInfoCtrl);
				return;
			}
			else if (checkInfo.m_iConsisChkFail)
			{
				project()->setIConsistPropMainProj(false);
				BDDHISC::Hisc_IConsisChkInfo checkInfoIC("Project is LD interface consistent.");
				checkInfoIC.m_chkPassed = false;
				checkInfoIC.m_errStr = checkInfo.m_errStr;
				output().show(checkInfoIC);
				return;
			}
			}
					}
		  }

		//check only returns here if a pass/fail result is available
		// need to set appropriate flags
		
			// all passed so update all statuses.
			project()->setLwNonBlockPropMainProj(true);
			project()->setLwCtrlPropMainProj(true);
			project()->setIConsistPropMainProj(true);

			// now need to send output to various tabs
			BDDHISC::Hisc_LWNBChkInfo checkInfoNB("Project is LD level-wise nonblocking.");
			checkInfoNB.m_chkPassed = true;
			output().show(checkInfoNB, OutputUiPart::eSetLastOutput, false /*no popup */);

			BDDHISC::Hisc_LWContChkInfo checkInfoCtrl("Project is LD level-wise controllable."); 
			checkInfoCtrl.m_chkPassed = true;
			output().show(checkInfoCtrl, OutputUiPart::eAppendLastOutput, false);

			BDDHISC::Hisc_IConsisChkInfo checkInfoIC("Project is LD interface consistent, LD level-wise nonblocking and LD level-wise controllable.");
			checkInfoIC.m_chkPassed = true;
			checkInfoIC.m_succStr = checkInfo.m_succStr;
			output().show(checkInfoIC, OutputUiPart::eAppendLastOutput, true);
		
		
		}
	}
  catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddSubsysIConsistTool()
{
  try
    {		

      WaitCursor wait(this);	

      if (m_pCrtSubsys == null)
	{
	  // no subsystem selected
	  return;
	}   

      int tmp;
      QString succMessage = "";

      // need to determine which subsystem to verify
      QString DESpotSubName = QString::fromStdWString(m_pCrtSubsys->getName());
      QString subSysName;
      bool isHigh = false;

      if (m_pCrtSubsys->isRoot())
	{
	  isHigh = true;
	}



      subSysName = QString::fromStdWString(m_pCrtSubsys->getName());
     
	  //Removed by Zain
	  // remove spaces from name
    /*  while (subSysName.contains(" "))
	{
	  subSysName.remove(' ');
	}*/

      

		if(project()->isBilevel())
		{
      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      if (isHigh)
	{
				BDDHISC::Hisc_SubIConsisChkInfo checkInfo("High Level subsystem '" + DESpotSubName + 
					"' is LD interface consistent.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckIConsist(*m_pProject, subSysName,
					isHigh, checkInfo); 
				project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
				//project()->procBddHighIConsistProp(checkInfo);
				output().show(checkInfo);
	}
      else
	{
				BDDHISC::Hisc_SubIConsisChkInfo checkInfo("Low Level subsystem '" + DESpotSubName + 
					"' is LD interface consistent.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckIConsist(*m_pProject, subSysName,
					isHigh, checkInfo); 
				project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
				//project()->procBddLowIConsistProp(checkInfo,*m_pCrtSubsys);
				output().show(checkInfo);
	}

		}
		else
		{
			if (project()->isValid() == false)
			{
				throw EX("Project integrity test must pass before running BDD algorithms.");
				return;
			}

			bool nonLeaf= false;
			DesSubsystem::DependIteratorPtr depIt = m_pCrtSubsys->createDependsIterator();
			for(depIt->first(); depIt->notDone(); depIt->next())
			{
				nonLeaf = true;
    }

			if (isHigh)
			{
				DesProject* desProj = m_pProject->extractionSystem(m_pCrtSubsys);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				
				BDDHISC::Hisc_SubIConsisChkInfo checkInfo("High Level subsystem '" + DESpotSubName + 
					"' is LD interface consistent.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckIConsist(*desProj, subSysName,
					isHigh, checkInfo); 
				project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
				output().show(true,false,checkInfo);
			}
			else if(isHigh==false && nonLeaf)
			{
				DesProject* desProjForHigh = m_pProject->extractionSystem(m_pCrtSubsys);
				
				BDDHISC::Hisc_SubIConsisChkInfo checkInfo("High/Low Level subsystem '" + DESpotSubName + 
					"' is LD interface consistent.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckIConsist(*desProjForHigh, subSysName,
					nonLeaf, checkInfo); 
				bool isHighICons=checkInfo.m_chkPassed;
				if(isHighICons==false)
				{
				project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,false);
				output().show(true,false,checkInfo);
				return;
				}

				const DesSubsystem& crtSubsysParent = m_pCrtSubsys->getInterface().getSubsystem();
				DesProject* desProjForLow = m_pProject->extractionSystem(&crtSubsysParent);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProjForLow);
				DesSubsystem::DependIteratorPtr lowSubsysIt = extractedProj->getRootSubsys().createDependsIterator();
				for(lowSubsysIt->first(); lowSubsysIt->isDone() == false; lowSubsysIt->next())
				{
					const DesSubsystem*  lowSubsys = lowSubsysIt->currentItem().subsystem;
					if(lowSubsys->getName() == m_pCrtSubsys->getName())
					{
						
				BDDHISC::Hisc_SubIConsisChkInfo checkInfo("High/Low Level subsystem '" + DESpotSubName + 
					"' is LD interface consistent.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckIConsist(*desProjForLow, subSysName,
					isHigh, checkInfo); 
				bool isLowICons=checkInfo.m_chkPassed;
				if(isLowICons==false)
				{
				project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,false);
				output().show(false,false,checkInfo);
				return;
				}
				}
				}

				project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,true);
				output().show(false,true,checkInfo);
			}
			else if(nonLeaf==false)
			{
				const DesSubsystem& crtSubsysParent = m_pCrtSubsys->getInterface().getSubsystem();
				DesProject* desProj = m_pProject->extractionSystem(&crtSubsysParent);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				DesSubsystem::DependIteratorPtr lowSubsysIt = extractedProj->getRootSubsys().createDependsIterator();
				for(lowSubsysIt->first(); lowSubsysIt->isDone() == false; lowSubsysIt->next())
				{
					const DesSubsystem*  lowSubsys = lowSubsysIt->currentItem().subsystem;
					if(lowSubsys->getName() == m_pCrtSubsys->getName())
					{
						
				BDDHISC::Hisc_SubIConsisChkInfo checkInfo("Low Level subsystem '" + DESpotSubName + 
					"' is LD interface consistent.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckIConsist(*desProj, subSysName,
					isHigh, checkInfo); 
				project()->setSubsysIConsistPropMainProj(*m_pCrtSubsys,desProj->getRootSubsys().isInterfConsist());
				output().show(false,false,checkInfo);
					}
				}
			}
				
		}

	}
    catch_display_ex()
}


//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddProjIConsistTool()
{
  try
    {
      
      WaitCursor wait(this);	

      int tmp;
      QString succMessage = "";

      // set to process all susbsytems
      QString subSysName =  "all!";
      // isHigh will be ignored
      bool isHigh = false;

      BDDHISC::Hisc_IConsisChkInfo checkInfo("Project is LD interface consistent.");
	 if(project()->isBilevel())
	  {
      tmp = BDDHISC::BddHiscCheckIConsist(*m_pProject, subSysName,
					    isHigh, checkInfo); 
  
      //check only returns here if a pass/fail result is available
	  // need to set appropriate flags
	  DesHierProject::SubsysIteratorPtr subsysAllIt = project()->createSubsysIterator();
	  for(subsysAllIt->first(); subsysAllIt->notDone(); subsysAllIt->next())
	  {
		  const DesSubsystem& subsysMainProj = subsysAllIt->currentItem();
		  DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
		  subsysNc.setInterfConsist(checkInfo.m_chkPassed);
	  }
	  DesHierProject::InterfIteratorPtr intrefAllIt = project()->createInterfIterator();
	  for(intrefAllIt->first(); intrefAllIt->notDone(); intrefAllIt->next())
	  {
		  const DesInterface& interfMainProj = intrefAllIt->currentItem();
		  DesInterface& interfNc= const_cast<DesInterface &>(interfMainProj);
		  interfNc.setInterfConsist(checkInfo.m_chkPassed);
	  }
	  project()->procBddIConsistProp(checkInfo);

      output().show(checkInfo);
	  }
	  else if(project()->isBilevel()==false && project()->isValid()==false)
	  {
      tmp = BDDHISC::BddHiscCheckIConsist(*m_pProject, subSysName,
					    isHigh, checkInfo); 

      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      project()->procBddIConsistProp(checkInfo);

      output().show(checkInfo);
	  }
	  else
	  {
		  DesHierProject::SubsysIteratorPtr subsysIt = project()->createSubsysIterator();
			for(subsysIt->first(); subsysIt->notDone(); subsysIt->next())
			{
				bool nonLeaf = false;
				DesSubsystem::DependIteratorPtr depIt = subsysIt->currentItem().createDependsIterator();
				for(depIt->first(); depIt->notDone(); depIt->next())
				{
					nonLeaf = true;
				}
				//call extraction against non-leaf node only
				if(nonLeaf)
				{
					const DesSubsystem& subsysExtraction = subsysIt->currentItem();
					DesProject* desProj = m_pProject->extractionSystem(&subsysExtraction);
					//DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
					tmp = BDDHISC::BddHiscCheckIConsist(*desProj, subSysName,
						isHigh, checkInfo); 
      
					//check only returns here if a pass/fail result is available
					// need to set appropriate flags
					if(checkInfo.m_chkPassed==false)
					{
						DesHierProject::SubsysIteratorPtr subsysAllIt = project()->createSubsysIterator();
						for(subsysAllIt->first(); subsysAllIt->notDone(); subsysAllIt->next())
						{
							const DesSubsystem& subsysMainProj = subsysAllIt->currentItem();
							DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
							subsysNc.setInterfConsist(false);
    }
						DesHierProject::InterfIteratorPtr intrefAllIt = project()->createInterfIterator();
						for(intrefAllIt->first(); intrefAllIt->notDone(); intrefAllIt->next())
						{
							const DesInterface& interfMainProj = intrefAllIt->currentItem();
							DesInterface& interfNc= const_cast<DesInterface &>(interfMainProj);
							interfNc.setInterfConsist(false);
						}
						project()->setIConsistPropMainProj(false);
						output().show(checkInfo);
						return;
					}
				}
			}
			DesHierProject::SubsysIteratorPtr subsysAllIt = project()->createSubsysIterator();
			for(subsysAllIt->first(); subsysAllIt->notDone(); subsysAllIt->next())
			{
				const DesSubsystem& subsysMainProj = subsysAllIt->currentItem();
				DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
				subsysNc.setInterfConsist(true);
			}
			DesHierProject::InterfIteratorPtr intrefAllIt = project()->createInterfIterator();
			for(intrefAllIt->first(); intrefAllIt->notDone(); intrefAllIt->next())
			{
				const DesInterface& interfMainProj = intrefAllIt->currentItem();
				DesInterface& interfNc= const_cast<DesInterface &>(interfMainProj);
				interfNc.setInterfConsist(true);
			}
			project()->setIConsistPropMainProj(true);

			output().show(checkInfo);
	  }
      
    }
    catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddSubsysNonblockingTool()
{
  try
    {	    
      WaitCursor wait(this);	
   
      if (m_pCrtSubsys == null)
	{
	  // no subsystem selected
	  return;
	}   

      int tmp;
      QString succMessage = "";

      // need to determine which subsystem to verify
      QString DESpotSubName = QString::fromStdWString(m_pCrtSubsys->getName());
      QString subSysName;
      bool isHigh = false;

		DesSubsystem::DependIteratorPtr depIt = m_pCrtSubsys->createDependsIterator();
		for(depIt->first(); depIt->notDone(); depIt->next())
	{
	  isHigh = true;
	}
		/*   if (m_pCrtSubsys->isRoot())
		{
		isHigh = true;
		}
		*/


      subSysName = QString::fromStdWString(m_pCrtSubsys->getName());

	  // removed by zain
      // remove spaces from name
     /* while (subSysName.contains(" "))
	{
	  subSysName.remove(' ');
	} */
      
		if(project()->isBilevel())
		{

      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      if (isHigh)
	{
				BDDHISC::Hisc_SubLWNBChkInfo checkInfo("High level subsystem '" + DESpotSubName + 
					"' is LD nonblocking.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckLWNonBlk(*m_pProject, subSysName,
					isHigh, checkInfo); 
				project()->setSubsysNonBlockPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
				//project()->procBddHighNonBlockProp(checkInfo);
				output().show(checkInfo);
	}
      else
	{
				BDDHISC::Hisc_SubLWNBChkInfo checkInfo("Low level subsystem '" + DESpotSubName + 
					"' is LD nonblocking.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckLWNonBlk(*m_pProject, subSysName,
					isHigh, checkInfo); 
				project()->setSubsysNonBlockPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
				//project()->procBddLowNonBlockProp(checkInfo,*m_pCrtSubsys);
				output().show(checkInfo);
	}
		}     

		else
		{
			if (project()->isValid() == false)
			{
				throw EX("Project integrity test must pass before running BDD algorithms.");
				return;
			}

			if (isHigh)
			{
				DesProject* desProj = m_pProject->extractionSystem(m_pCrtSubsys);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				
				BDDHISC::Hisc_SubLWNBChkInfo checkInfo("High level subsystem '" + DESpotSubName + 
					"' is LD nonblocking.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckLWNonBlk(*desProj, subSysName,
					isHigh, checkInfo); 
				project()->setSubsysNonBlockPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
				output().show(isHigh,checkInfo);
    }
			else
			{
				const DesSubsystem& crtSubsysParent = m_pCrtSubsys->getInterface().getSubsystem();
				DesProject* desProj = m_pProject->extractionSystem(&crtSubsysParent);
				DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
				DesSubsystem::DependIteratorPtr lowSubsysIt = extractedProj->getRootSubsys().createDependsIterator();
				for(lowSubsysIt->first(); lowSubsysIt->isDone() == false; lowSubsysIt->next())
				{
					const DesSubsystem*  lowSubsys = lowSubsysIt->currentItem().subsystem;
					if(lowSubsys->getName() == m_pCrtSubsys->getName())
					{
						
				BDDHISC::Hisc_SubLWNBChkInfo checkInfo("Low level subsystem '" + DESpotSubName + 
					"' is LD nonblocking.", DESpotSubName);
				tmp = BDDHISC::BddHiscCheckLWNonBlk(*desProj, subSysName,
					isHigh, checkInfo); 
				project()->setSubsysNonBlockPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
				output().show(isHigh,checkInfo);
					}
				}
			}
		}

	}
    catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddLevelWiseNonblockingTool()
{
  try
    {	
	
      WaitCursor wait(this);	

      int tmp;
      QString succMessage = "";

      // set to process all susbsytems
      QString subSysName =  "all!";
      // isHigh will be ignored
      bool isHigh = false;

      BDDHISC::Hisc_LWNBChkInfo checkInfo("Project is LD level-wise nonblocking.");

	  if(project()->isBilevel())
	  {
      tmp = BDDHISC::BddHiscCheckLWNonBlk(*m_pProject, subSysName,
					    isHigh, checkInfo); 

       // set appropriate flags for des of all subsytems
	  DesHierProject::SubsysIteratorPtr subsysIt1 = project()->createSubsysIterator();
	  for(subsysIt1->first(); subsysIt1->notDone(); subsysIt1->next())
	  {
		  const DesSubsystem& subsysMainProj = subsysIt1->currentItem();
		  DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
		  subsysNc.setNonBlocking(checkInfo.m_chkPassed);
		 
	  }
      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      project()->procBddLwNonBlockProp(checkInfo);

      output().show(checkInfo);
	  }
	  else if(project()->isBilevel()==false && project()->isValid()==false)
	  {
		  tmp = BDDHISC::BddHiscCheckLWNonBlk(*m_pProject, subSysName,
					    isHigh, checkInfo); 

      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      project()->procBddLwNonBlockProp(checkInfo);
  
      output().show(checkInfo);
	}
	  else
	  {
		  DesHierProject::SubsysIteratorPtr subsysIt = project()->createSubsysIterator();
		  for(subsysIt->first(); subsysIt->notDone(); subsysIt->next())
			{
				bool nonLeaf = false;
				DesSubsystem::DependIteratorPtr depIt = subsysIt->currentItem().createDependsIterator();
					for(depIt->first(); depIt->notDone(); depIt->next())
					{
						nonLeaf = true;
					}
				//call extraction against non-leaf node only
					if(nonLeaf)
					{
						const DesSubsystem& subsysExtraction = subsysIt->currentItem();
						DesProject* desProj = project()->extractionSystem(&subsysExtraction);
						//DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);

						tmp = BDDHISC::BddHiscCheckLWNonBlk(*desProj, subSysName,
							isHigh, checkInfo);

						if(checkInfo.m_chkPassed==false)
						{
							//set non blocking flag for all the des in the main project to false
							DesHierProject::SubsysIteratorPtr subsysIt1 = project()->createSubsysIterator();
							for(subsysIt1->first(); subsysIt1->notDone(); subsysIt1->next())
							{
								const DesSubsystem& subsysMainProj = subsysIt1->currentItem();
								DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
								subsysNc.setNonBlocking(false);
							}
							project()->setLwNonBlockPropMainProj(false);
							output().show(checkInfo);
							return;

						}
					}
		  }
		  DesHierProject::SubsysIteratorPtr subsysIt1 = project()->createSubsysIterator();
		  for(subsysIt1->first(); subsysIt1->notDone(); subsysIt1->next())
		  {
			  const DesSubsystem& subsysMainProj = subsysIt1->currentItem();
			  DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
			  subsysNc.setNonBlocking(true);
		  }
		  project()->setLwNonBlockPropMainProj(true);
		  output().show(checkInfo);
	  }
  
	}
	catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddSubsysCtrlTool()
{
  try
    {		

      WaitCursor wait(this);	

      if (m_pCrtSubsys == null)
	{
	  // no subsystem selected
	  return;
	}   

      int tmp;
      QString succMessage = "";
      
      // need to determine which subsystem to verify
      QString DESpotSubName = QString::fromStdWString(m_pCrtSubsys->getName());

      QString subSysName;
      bool isHigh = false;

      if (m_pCrtSubsys->isRoot())
	{
	  isHigh = true;
	}

      subSysName = QString::fromStdWString(m_pCrtSubsys->getName());
    //removed by zain
	  /*
	  // remove spaces from name
      while (subSysName.contains(" "))
	{
	  subSysName.remove(' ');
	} */
	  if(project()->isBilevel())
	  {
      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
      if (isHigh)
	{
		 BDDHISC::Hisc_SubLWContChkInfo checkInfo("High level subsystem '" + DESpotSubName + 
		     "' is LD controllable.", DESpotSubName); 

		 tmp = BDDHISC::BddHiscCheckLWCtrl(*m_pProject, subSysName,
			 isHigh, checkInfo);
	
		  project()->setSubsysCtrlPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
		 //project()->procBddHighCtrlProp(checkInfo);
		 output().show(checkInfo);
	  }
	  else
	  {
		  BDDHISC::Hisc_SubLWContChkInfo checkInfo("Low level subsystem '" + DESpotSubName + 
			  "' is LD controllable.", DESpotSubName); 

      tmp = BDDHISC::BddHiscCheckLWCtrl(*m_pProject, subSysName,
					    isHigh, checkInfo); 
		  project()->setSubsysCtrlPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
		  //project()->procBddLowCtrlProp(checkInfo,*m_pCrtSubsys);
		  output().show(checkInfo);
	  }
	  }
	  else
	  {
		  if (project()->isValid() == false)
			{
				throw EX("Project integrity test must pass before running BDD algorithms.");
				return;
			}

      if (isHigh)
	{
			  DesProject* desProj = m_pProject->extractionSystem(m_pCrtSubsys);
			  DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
			  
			  BDDHISC::Hisc_SubLWContChkInfo checkInfo("High level subsystem '" + DESpotSubName + 
				  "' is LD controllable.", DESpotSubName); 

			  tmp = BDDHISC::BddHiscCheckLWCtrl(*desProj, subSysName,
				  isHigh, checkInfo);
			  project()->setSubsysCtrlPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
			  output().show(isHigh,checkInfo);
	}
      else
	{
		  const DesSubsystem& crtSubsysParent = m_pCrtSubsys->getInterface().getSubsystem();
		  DesProject* desProj = m_pProject->extractionSystem(&crtSubsysParent);
		  DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
		  DesSubsystem::DependIteratorPtr lowSubsysIt = extractedProj->getRootSubsys().createDependsIterator();
		  for(lowSubsysIt->first(); lowSubsysIt->isDone() == false; lowSubsysIt->next())
		  {
			  const DesSubsystem*  lowSubsys = lowSubsysIt->currentItem().subsystem;
			  if(lowSubsys->getName() == m_pCrtSubsys->getName())
			  {
				  BDDHISC::Hisc_SubLWContChkInfo checkInfo("Low level subsystem '" + DESpotSubName + 
					  "' is LD controllable.", DESpotSubName); 

				  tmp = BDDHISC::BddHiscCheckLWCtrl(*desProj, subSysName,
					  isHigh, checkInfo);
				  project()->setSubsysCtrlPropMainProj(*m_pCrtSubsys,checkInfo.m_chkPassed);
				  output().show(isHigh,checkInfo);
	}
				}
		  }

	  }

    }
    catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddLevelWiseCtrlTool()
{
  try
    {		

      WaitCursor wait(this);

      int tmp;
      QString succMessage = "";

      // set to process all susbsytems
      QString subSysName =  "all!";
      // isHigh will be ignored
      bool isHigh = false;

      BDDHISC::Hisc_LWContChkInfo checkInfo("Project is LD level-wise controllable."); 
	  if(project()->isBilevel())
	  {
      tmp = BDDHISC::BddHiscCheckLWCtrl(*m_pProject, subSysName,
					    isHigh, checkInfo); 

      //check only returns here if a pass/fail result is available
      // need to set appropriate flags
	  DesHierProject::SubsysIteratorPtr subsysIt1 = project()->createSubsysIterator();
	  for(subsysIt1->first(); subsysIt1->notDone(); subsysIt1->next())
	  {
		  const DesSubsystem& subsysMainProj = subsysIt1->currentItem();
		  DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
		  subsysNc.setControllable(checkInfo.m_chkPassed);
		 
	  }
	

      project()->procBddLwCtrlProp(checkInfo);

      output().show(checkInfo);
	  }
	  else if(project()->isBilevel()== false && project()->isValid()==false)
	  {
		   tmp = BDDHISC::BddHiscCheckLWCtrl(*m_pProject, subSysName,
					    isHigh, checkInfo); 
      
      project()->procBddLwCtrlProp(checkInfo);

      output().show(checkInfo);
    }
	  else
	  {
		  DesHierProject::SubsysIteratorPtr subsysIt = project()->createSubsysIterator();
			for(subsysIt->first(); subsysIt->notDone(); subsysIt->next())
			{
				bool nonLeaf = false;
				DesSubsystem::DependIteratorPtr depIt = subsysIt->currentItem().createDependsIterator();
					for(depIt->first(); depIt->notDone(); depIt->next())
					{
						nonLeaf = true;
					}
				//call extraction against non-leaf node only
					if(nonLeaf)
					{
						const DesSubsystem& subsysExtraction = subsysIt->currentItem();
						DesProject* desProj = project()->extractionSystem(&subsysExtraction);
						//DesHierProject* extractedProj = dynamic_cast<DesHierProject*>(desProj);
						tmp = BDDHISC::BddHiscCheckLWCtrl(*desProj, subSysName,
							isHigh, checkInfo); 

						if(checkInfo.m_chkPassed==false)
						{
							DesHierProject::SubsysIteratorPtr subsysIt1 = project()->createSubsysIterator();
							for(subsysIt1->first(); subsysIt1->notDone(); subsysIt1->next())
							{
								const DesSubsystem& subsysMainProj = subsysIt1->currentItem();
								DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
								subsysNc.setControllable(false);
							}
							project()->setLwCtrlPropMainProj(false);
							output().show(checkInfo);
							return;
						}
					}
			}
			DesHierProject::SubsysIteratorPtr subsysIt1 = project()->createSubsysIterator();
			for(subsysIt1->first(); subsysIt1->notDone(); subsysIt1->next())
			{
				const DesSubsystem& subsysMainProj = subsysIt1->currentItem();
				DesSubsystem& subsysNc= const_cast<DesSubsystem &>(subsysMainProj);
				subsysNc.setControllable(true);
			}
			project()->setLwCtrlPropMainProj(true);
			output().show(checkInfo);
			
	  }
      
    }
    catch_display_ex()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunBddLevelWiseSynthesisTool()
{
  try

    {
	if(project()->isBilevel() == false)
	{		
		QMessageBox::information(this, "DESpot","HISC level-wise synthesis is currently not supported for multilevel hierarchy");
		return;
	}
      SubsystemLWSynDialog synth(this);
      if(synth.exec())
	{
	  char choice = synth.Choice();
	  // choice = b for bdd, d for DES, and o for  both.
	  // e means error
	  assert(choice != 'e');
	  if (choice == 'e')
	    {
	    return;
	    }

	  WaitCursor wait(this);	


	  QString absoluteFileName = m_pProject->isNew()? QString::fromStdWString(m_pProject->getName()) : QString::fromStdWString(m_pProject->getFileName());

	  QString absPath = QFileInfo(absoluteFileName).absolutePath();
	  
	  int tmp;

	  // set to process all susbsytems
	  QString subSysName =  "all!";
	  // isHigh will be ignored
	  bool isHigh = false;

	  BDDHISC::Hisc_LWSynthChkInfo checkInfo("Level-wise synthesis successful.");

          tmp = BDDHISC::BddHiscLWSynth(*m_pProject, choice, absPath,
          subSysName, isHigh, checkInfo);

	  // only returns if successful.
	  output().show(checkInfo);

	  //	  QMessageBox::information(this, "DESpot",checkInfo.m_succStr);
	  
	}
    }
    catch_display_ex()
      
}

void HierProjectEditor::onRunBDDSubsysLWSynTool()
{
  try
    {
	if(project()->isBilevel() == false)
	{		
		QMessageBox::information(this, "DESpot","HISC level-wise synthesis is currently not supported for multilevel hierarchy");
		return;
	}
  
      
      if (m_pCrtSubsys == null)
	{
	  // no subsystem selected
	  return;
	  }

      SubsystemLWSynDialog synth(this);
      if(synth.exec())
	{
	  char choice = synth.Choice();
	  // choice = b for bdd, d for DES, and o for  both.
	  // e means error
	  assert(choice != 'e');
	  if (choice == 'e')
	    {
	      return;
	    }

	  WaitCursor wait(this);	

	  QString absoluteFileName = m_pProject->isNew()? QString::fromStdWString(m_pProject->getName()) : QString::fromStdWString(m_pProject->getFileName());

	  QString absPath = QFileInfo(absoluteFileName).absolutePath();
	  

	  int tmp;
	  QString succMessage = "";

	  // need to determine which subsystem to synthesize
	  QString DESpotSubName = QString::fromStdWString(m_pCrtSubsys->getName());
	  QString subSysName;
	  bool isHigh = false;

	  if (m_pCrtSubsys->isRoot())
	    {
	      isHigh = true;
	    }

	  BDDHISC::Hisc_SubLWSynthChkInfo checkInfo("Synthesis successful for subsystem '" + DESpotSubName + ".'", DESpotSubName); 

	  subSysName = QString::fromStdWString(m_pCrtSubsys->getName());
	  // removed by zain
	  /*
	  // remove spaces from name
	  while (subSysName.contains(" "))
	    {
	      subSysName.remove(' ');
	    }

		*/
          tmp = BDDHISC::BddHiscLWSynth(*m_pProject, choice, absPath,
          subSysName, isHigh, checkInfo);

	  // only returns if successful.
	  output().show(checkInfo);
	  //	  QMessageBox::information(this, "DESpot",checkInfo.m_succStr);
	  
	}
    }
  catch_display_ex()
}
#endif

//_________________________________________________________________________________________________

// Added by David for Distributed Tools

void HierProjectEditor::onRunDistCheckAll()
{
	try
	{		

#ifdef __ENABLE_DIST__
		if (!(dynamic_cast<DesHierProject*>(m_pProject)->isBilevel()))
		{
			QMessageBox::information(this, "DESpot","Distributed checks are only implemented for bi-level HISC systems");
			return;
		}
		if (!m_pProject->isValid())
		{
			QMessageBox::information(this, "DESpot","Project Invalid or Integrity has not been checked");
			return;
		}

		if (m_pProject->isNew() || m_pProject->isModified())
		{
			QMessageBox::information(this, "DESpot", "You have unsaved changes that must be committed/reverted before calling a Distributed algorithm");
			return;
		}

		if (HostFileManager::length() <= 0)
		{
			QMessageBox::information(this, "DESpot","No hosts configured");
			return;
		}

		DistHandler dh(m_pProject);

		// get start time
		time_t tstart;
        	time(&tstart);

		resultStruct rs = dh.runHISCCheck(All, false, false);	

		// get end time
		time_t tend;
        	time(&tend);

		HierProjectPropCheck projCheckAlgo(*project(), false);
		projCheckAlgo.levelWiseNonBlockAlgo().overrideLwNonBlocking(rs.nonBlocking);
		projCheckAlgo.levelWiseCtrlAlgo().overrideLwControllable(rs.controllable);
		projCheckAlgo.interfConsistAlgo().overrideInterfConsist(rs.iConsistent);

		dynamic_cast<DesHierProject*>(m_pProject)->onLwNonBlockStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onLwNonBlockStatusChanged();

		dynamic_cast<DesHierProject*>(m_pProject)->onLwCtrlStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onLwCtrlStatusChanged();

		dynamic_cast<DesHierProject*>(m_pProject)->onIConsistStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onIConsistStatusChanged();

		output().show(rs, tend - tstart);
#endif
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eProjectPropCheck, L"An error occurred while checking the project's properties", e);
	}
	catch_display_all()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunDistLWNB()
{
	try
	{		

#ifdef __ENABLE_DIST__

		if (!(dynamic_cast<DesHierProject*>(m_pProject)->isBilevel()))
		{
			QMessageBox::information(this, "DESpot","Distributed checks are only implemented for bi-level HISC systems");
			return;
		}
		if (!m_pProject->isValid())
		{
			QMessageBox::information(this, "DESpot","Project Invalid or Integrity has not been checked");
			return;
		}

		if (m_pProject->isNew() || m_pProject->isModified())
		{
			QMessageBox::information(this, "DESpot", "You have unsaved changes that must be committed/reverted before calling a Distributed algorithm");
			return;
		}

		if (HostFileManager::length() <= 0)
		{
			QMessageBox::information(this, "DESpot","No hosts configured");
			return;
		}

		
		HierProjectPropCheck projCheckAlgo(*project(), true);
		DistHandler dh(m_pProject);		

		// get start time
		time_t tstart;
        	time(&tstart);

		resultStruct rs = dh.runHISCCheck(nonBlocking, false, false);	

		// get end time
		time_t tend;
        	time(&tend);	

		projCheckAlgo.levelWiseNonBlockAlgo().overrideLwNonBlocking(rs.nonBlocking);

		dynamic_cast<DesHierProject*>(m_pProject)->onLwNonBlockStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onLwNonBlockStatusChanged();

		output().show(rs, tend - tstart);
#endif
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eProjectPropCheck, L"An error occurred while checking the project's properties", e);
	}
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunDistLWCtrl()
{
	try
	{		

#ifdef __ENABLE_DIST__

		if (!(dynamic_cast<DesHierProject*>(m_pProject)->isBilevel()))
		{
			QMessageBox::information(this, "DESpot","Distributed checks are only implemented for bi-level HISC systems");
			return;
		}
		if (!m_pProject->isValid())
		{
			QMessageBox::information(this, "DESpot","Project Invalid or Integrity has not been checked");
			return;
		}

		if (m_pProject->isNew() || m_pProject->isModified())
		{
			QMessageBox::information(this, "DESpot", "You have unsaved changes that must be committed/reverted before calling a Distributed algorithm");
			return;
		}

		if (HostFileManager::length() <= 0)
		{
			QMessageBox::information(this, "DESpot","No hosts configured");
			return;
		}

		
		HierProjectPropCheck projCheckAlgo(*project(), true);
		DistHandler dh(m_pProject);
		
		// get start time
		time_t tstart;
        	time(&tstart);

		resultStruct rs = dh.runHISCCheck(controllable, false, false);	

		// get end time
		time_t tend;
        	time(&tend);	

		projCheckAlgo.levelWiseCtrlAlgo().overrideLwControllable(rs.controllable);

		dynamic_cast<DesHierProject*>(m_pProject)->onLwCtrlStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onLwCtrlStatusChanged();

		output().show(rs, tend - tstart);
#endif
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eProjectPropCheck, L"An error occurred while checking the project's properties", e);
	}
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunDistIConsist()
{
	try
	{		

#ifdef __ENABLE_DIST__

		if (!(dynamic_cast<DesHierProject*>(m_pProject)->isBilevel()))
		{
			QMessageBox::information(this, "DESpot","Distributed checks are only implemented for bi-level HISC systems");
			return;
		}
		if (!m_pProject->isValid())
		{
			QMessageBox::information(this, "DESpot","Project Invalid or Integrity has not been checked");
			return;
		}

		if (m_pProject->isNew() || m_pProject->isModified())
		{
			QMessageBox::information(this, "DESpot", "You have unsaved changes that must be committed/reverted before calling a Distributed algorithm");
			return;
		}

		if (HostFileManager::length() <= 0)
		{
			QMessageBox::information(this, "DESpot","No hosts configured");
			return;
		}

		
		HierProjectPropCheck projCheckAlgo(*project(), true);
		DistHandler dh(m_pProject);
		
		// get start time
		time_t tstart;
        	time(&tstart);

		resultStruct rs = dh.runHISCCheck(iConsist, false, false);	

		// get end time
		time_t tend;
        	time(&tend);	

		projCheckAlgo.interfConsistAlgo().overrideInterfConsist(rs.iConsistent);

		dynamic_cast<DesHierProject*>(m_pProject)->onIConsistStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onIConsistStatusChanged();

		output().show(rs, tend - tstart);
#endif
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eProjectPropCheck, L"An error occurred while checking the project's properties", e);
	}
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunDistBDDCheckAll()
{
	try
	{	

#ifdef __ENABLE_DIST__

		if (!(dynamic_cast<DesHierProject*>(m_pProject)->isBilevel()))
		{
			QMessageBox::information(this, "DESpot","Distributed checks are only implemented for bi-level HISC systems");
			return;
		}
		if (!m_pProject->isValid())
		{
			QMessageBox::information(this, "DESpot","Project Invalid or Integrity has not been checked");
			return;
		}

		if (m_pProject->isNew() || m_pProject->isModified())
		{
			QMessageBox::information(this, "DESpot", "You have unsaved changes that must be committed/reverted before calling a Distributed algorithm");
			return;
		}

		if (HostFileManager::length() <= 0)
		{
			QMessageBox::information(this, "DESpot","No hosts configured");
			return;
		}

		
		HierProjectPropCheck projCheckAlgo(*project(), false);
		DistHandler dh(m_pProject);
		
		// get start time
		time_t tstart;
        	time(&tstart);

		resultStruct rs = dh.runHISCCheck(All, true, false);	

		// get end time
		time_t tend;
        	time(&tend);	

		projCheckAlgo.levelWiseNonBlockAlgo().overrideLwNonBlocking(rs.nonBlocking);
		projCheckAlgo.levelWiseCtrlAlgo().overrideLwControllable(rs.controllable);
		projCheckAlgo.interfConsistAlgo().overrideInterfConsist(rs.iConsistent);

		dynamic_cast<DesHierProject*>(m_pProject)->onLwNonBlockStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onLwNonBlockStatusChanged();

		dynamic_cast<DesHierProject*>(m_pProject)->onLwCtrlStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onLwCtrlStatusChanged();

		dynamic_cast<DesHierProject*>(m_pProject)->onIConsistStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onIConsistStatusChanged();

		output().show(rs, tend - tstart);
#endif
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eProjectPropCheck, L"An error occurred while checking the project's properties", e);
	}
	catch_display_all()
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunDistBDDLWNB()
{
	try
	{		

#ifdef __ENABLE_DIST__

		if (!(dynamic_cast<DesHierProject*>(m_pProject)->isBilevel()))
		{
			QMessageBox::information(this, "DESpot","Distributed checks are only implemented for bi-level HISC systems");
			return;
		}
		if (!m_pProject->isValid())
		{
			QMessageBox::information(this, "DESpot","Project Invalid or Integrity has not been checked");
			return;
		}

		if (m_pProject->isNew() || m_pProject->isModified())
		{
			QMessageBox::information(this, "DESpot", "You have unsaved changes that must be committed/reverted before calling a Distributed algorithm");
			return;
		}

		if (HostFileManager::length() <= 0)
		{
			QMessageBox::information(this, "DESpot","No hosts configured");
			return;
		}

		
		HierProjectPropCheck projCheckAlgo(*project(), true);
		DistHandler dh(m_pProject);
		
		// get start time
		time_t tstart;
        	time(&tstart);

		resultStruct rs = dh.runHISCCheck(nonBlocking, true, false);	

		// get end time
		time_t tend;
        	time(&tend);	

		projCheckAlgo.levelWiseNonBlockAlgo().overrideLwNonBlocking(rs.nonBlocking);

		dynamic_cast<DesHierProject*>(m_pProject)->onLwNonBlockStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onLwNonBlockStatusChanged();

		output().show(rs, tend - tstart);		
#endif
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eProjectPropCheck, L"An error occurred while checking the project's properties", e);
	}
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunDistBDDLWCtrl()
{
	try
	{		

#ifdef __ENABLE_DIST__

		if (!(dynamic_cast<DesHierProject*>(m_pProject)->isBilevel()))
		{
			QMessageBox::information(this, "DESpot","Distributed checks are only implemented for bi-level HISC systems");
			return;
		}
		if (!m_pProject->isValid())
		{
			QMessageBox::information(this, "DESpot","Project Invalid or Integrity has not been checked");
			return;
		}

		if (m_pProject->isNew() || m_pProject->isModified())
		{
			QMessageBox::information(this, "DESpot", "You have unsaved changes that must be committed/reverted before calling a Distributed algorithm");
			return;
		}

		if (HostFileManager::length() <= 0)
		{
			QMessageBox::information(this, "DESpot","No hosts configured");
			return;
		}

		
		HierProjectPropCheck projCheckAlgo(*project(), true);
		DistHandler dh(m_pProject);
		
		// get start time
		time_t tstart;
        	time(&tstart);

		resultStruct rs = dh.runHISCCheck(controllable, true, false);	

		// get end time
		time_t tend;
        	time(&tend);

		projCheckAlgo.levelWiseCtrlAlgo().overrideLwControllable(rs.controllable);

		dynamic_cast<DesHierProject*>(m_pProject)->onLwCtrlStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onLwCtrlStatusChanged();

		output().show(rs, tend - tstart);		
#endif
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eProjectPropCheck, L"An error occurred while checking the project's properties", e);
	}
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunDistBDDIConsist()
{
	try
	{		

#ifdef __ENABLE_DIST__

		if (!(dynamic_cast<DesHierProject*>(m_pProject)->isBilevel()))
		{
			QMessageBox::information(this, "DESpot","Distributed checks are only implemented for bi-level HISC systems");
			return;
		}
		if (!m_pProject->isValid())
		{
			QMessageBox::information(this, "DESpot","Project Invalid or Integrity has not been checked");
			return;
		}

		if (m_pProject->isNew() || m_pProject->isModified())
		{
			QMessageBox::information(this, "DESpot", "You have unsaved changes that must be committed/reverted before calling a Distributed algorithm");
			return;
		}

		if (HostFileManager::length() <= 0)
		{
			QMessageBox::information(this, "DESpot","No hosts configured");
			return;
		}

		
		HierProjectPropCheck projCheckAlgo(*project(), true);
		DistHandler dh(m_pProject);
		
		// get start time
		time_t tstart;
        	time(&tstart);	

		resultStruct rs = dh.runHISCCheck(iConsist, true, false);	

		// get end time
		time_t tend;
        	time(&tend);

		projCheckAlgo.interfConsistAlgo().overrideInterfConsist(rs.iConsistent);

		dynamic_cast<DesHierProject*>(m_pProject)->onIConsistStatusChecked();
		dynamic_cast<DesHierProject*>(m_pProject)->onIConsistStatusChanged();

		output().show(rs, tend - tstart);
#endif
	}
	catch(const std::wstring& e)
	{
		output().show(OutputUiPart::eProjectPropCheck, L"An error occurred while checking the project's properties", e);
	}
}

//_________________________________________________________________________________________________

void HierProjectEditor::onRunDistBDDSynth()
{
	try
	{		
#ifdef __ENABLE_DIST__

		if (!(dynamic_cast<DesHierProject*>(m_pProject)->isBilevel()))
		{
			QMessageBox::information(this, "DESpot","Distributed synthesis is only implemented for bi-level HISC systems");
			return;
		}
		if (m_pProject->isNew() || m_pProject->isModified())
		{
			QMessageBox::information(this, "DESpot", "You have unsaved changes that must be committed/reverted before calling a Distributed algorithm");
			return;
		}

		if (HostFileManager::length() <= 0)
		{
			QMessageBox::information(this, "DESpot","No hosts configured");
			return;
		}

		SubsystemLWSynDialog synth(this);
		if(synth.exec())
		{
			char choice = synth.Choice();
			// choice = b for bdd, d for DES, and o for  both.
			// e means error
			assert(choice != 'e');
			if (choice == 'e')
			{
				return;
			}

			WaitCursor wait(this);	

			DistHandler dh(m_pProject);

			// get start time
			time_t tstart;
        		time(&tstart);

			DesAlgo::ErrorList errList = dh.runSynth(choice);

			// get end time
			time_t tend;
	        	time(&tend);

			
			// build QString
			QString succMessage = "Synthesis completed successfully";			
			while (!errList.empty())
			{
				succMessage.append(QString::fromStdWString(errList.front()));

				errList.pop_front();
			}

			// append time
			stringstream ss;
			ss << "\n\nTotal computing time: " << tend - tstart << " second(s)";
			succMessage.append(QString::fromStdString(ss.str()));

			// only returns if successful.

	  BDDHISC::Hisc_LWSynthChkInfo checkInfo("Level-wise synthesis\
 successful.");

	  checkInfo.m_succStr = succMessage;
	  output().show(checkInfo);
			  //			QMessageBox::information(this, "DESpot",succMessage);
	  	}
		else
		{
			QMessageBox::information(this, "DESpot","An error occured during synthesis");
		}
#endif
	}
	catch_display_ex()
}

} //end of namespace DESpot

