#ifndef SIMSTATENODE_H
#define SIMSTATENODE_H

#include <QList>
#include <QString>
#include "Des.h"
#include "DesState.h"

namespace DESpot
{
class Node
{
public:
	// We only need to know if this is a meta data or des. 
	// if des, we need to populate state column
    enum Type { MetaData, DES, StateTuple };

    Node(Type type, const Des* des, const DesState* sta, bool viewerVisible);
	Node(const QString &meta = "");
    ~Node();

    Type type;
	const Des* des;
	QString desName;
	const DesState* state;
    QString stateName;
	QString initCol;
	QString markedCol;
    Node *parent;
    QList<Node *> children;
    bool viewerVisible;
    bool isBlockingDes;
};
}
#endif
