/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QDialog>
#include "ui_AddDesToProject.h"
#include "DesFlatProject.h"
#include "DesHierProject.h"

namespace DESpot
{
	class AddDesToProjectDlg: public QDialog, private Ui::AddDesToProjectDlg
	{
		Q_OBJECT	

		public:
			AddDesToProjectDlg(const DesProject& project, QWidget* parent = null);
			virtual ~AddDesToProjectDlg(void);

		public:
			//Hierarhical level - used only for adding a DES to a hierarhical project
			ProjectLevel getHierLevel() const;
			void setHierLevel(ProjectLevel level);

			//The name of the DES container
			std::wstring getContainerName() const;
			void setContainerName(const std::wstring& containerName);
			
			//The type of DES to be added: Plant or Supervisor. Note that when the DES
			//is to be added to the Interface level the DES type is unacessible
			DesLevel getDesLevel() const;
			void setDesLevel(DesLevel desLevel);

			//When the user adds a new DES isNewDes returns true. In this case a new DES is to be created
			//If an existing DES is to be added the method will return false
			bool isNewDes() const;
			
			//Used for new DESs to return the name given by the user to the DES
			std::wstring getNewDesName() const;

			//Used for existing DESs to return the name of file where the existing DES is saved
			std::wstring getDesFileName() const;

		//Overridables
		protected:
			virtual void accept();
			virtual void reject();

		private slots:
			void onBrowseDesFile();
			void onNewDesNameChanged(const QString& text);
			void onDesFileNameChanged(const QString& text);
			void onLevelChanged(int crtLevel);

		//Implementation method
		private:
			//Initializes controls depending on the project type
			void prepareDlgForProjectType();

			//Shows / hides the widgets specific to HISC projects
			void showHierProjectControls(bool show = true);

			//Fills the DES container wiget with the names of all possible containers
			//depending on the selected level
			void fillDesContainerWidget();

			//Update widgets from dialog data
			void updateUI();
			void updateProjectLevelUI();
			void updateDesLevelUI();
			void updateDesContainerUI();
			void updateAddMethodUI();
			void enableDesTypeUI(bool bEnable = true);

			//Update data from UI widgets
			bool updateData();
			bool updateLevel();
			bool updateDesType();
			bool updateDesContainer();
			bool updateAddMethod();
			
			//Groups the radio buttons to function properly
			void setupButtonGroups();
			
			const DesHierProject& hierProject();

		private:
			//The project the DES is to be added to. Note that dialog will NOT add the
			//DES to the project. It is up to the caller to do that. The dialog uses
			//the project only to obtain information from it (e.g. its type, list of interfaces,
			//low-level subsystems etc)
			const DesProject& m_project;

			//The level the DES is to be added in a HISC project
			ProjectLevel m_hierLevel;

			//The name of the container that will contain the DES in a HISC project
			std::wstring m_containerName;

			//The type of DES to be added: Plant or Supervisor. Note that when the DES
			//is to be added to the Interface level the DES type is unacessible
			DesLevel m_desLevel;
			
			//The last used DES type. The dialog uses this to initialze m_desLevel
			static DesLevel m_lastUsedDesLevel;

			//Flag reflecting user's choice of whether to add a new or existing DES
			bool m_isNewDes;

			//The name of the new DES
			std::wstring m_newDesName;

			//The file name of an existing DES
			std::wstring m_desFileName;

			//Radio button groups
			QButtonGroup* m_levelRadioBtnGroup;
			QButtonGroup* m_desLevelRadioBtnGroup;
			QButtonGroup* m_addMethodRadioBtnGroup;
	};

} //end of namespace DESpot
