/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "FlatProjStructureUiPart.h"
#include "CommonDefinitions.h"
#include "DesFlatProject.h"

namespace DESpot
{

FlatProjStructureUiPart::FlatProjStructureUiPart(Ui::FlatProjectEditorUI* pUiContainer, DesFlatProject* pProject):
	ProjStructureUiPart(pProject)
{
	initWidgets(pUiContainer);

	setupProjectStructWidget();	

	setupConnections();

	loadProjectStruct();
}

//_________________________________________________________________________________________________

FlatProjStructureUiPart::~FlatProjStructureUiPart(void)
{
}

//_________________________________________________________________________________________________

DesFlatProject& FlatProjStructureUiPart::project()
{
	return dynamic_cast<DesFlatProject&>(*m_pProject);	
}

//_________________________________________________________________________________________________

void FlatProjStructureUiPart::loadProjectStruct()
{
	addSupDesToUiItem();
	addPlantDesToUiItem();
	//add by bini
	addTemplateDesToUiItem();
	//addInstToUiItem();
//bini
}

//_________________________________________________________________________________________________

void FlatProjStructureUiPart::addSupDesToUiItem()
{							  
	DesProject::DesIteratorPtr desIt = m_pProject->createDesIterator(eSupervisorDes);
	ProjStructureUiPart::addSupDesToUiItem(m_flatStructSupUiItem, desIt);
}

//_________________________________________________________________________________________________
//add by bini
void FlatProjStructureUiPart::addTemplateDesToUiItem()
{							  
	DesProject::DesIteratorPtr desIt = m_pProject->createDesIterator(eTemplateDes);
	DesProject::InstIteratorPtr instIt=m_pProject->createInstIterator();
	ProjStructureUiPart::addTemplateDesToUiItem(m_flatStructTemplateUiItem, desIt,instIt);
	
	

}

//bini
//_________________________________________________________________________________________________

void FlatProjStructureUiPart::addPlantDesToUiItem()
{
	DesProject::DesIteratorPtr desIt = m_pProject->createDesIterator(ePlantDes);
	ProjStructureUiPart::addPlantDesToUiItem(m_flatStructPlantUiItem, desIt);
}

void FlatProjStructureUiPart::addInstToUiItem()

{
	DesProject::InstIteratorPtr instIt=m_pProject->createInstIterator();
	ProjStructureUiPart::addInstToUiItem(m_flatStructInstUiItem,instIt);
}

} //end of namespace DESpot
