/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <map>
#include <vector>
#include "DesEvent.h"
#include "Des.h"
#include "DesProject.h"

namespace DESpot
{
	class EventTranslator
	{
		public:
			EventTranslator(bool completeTranslation = true);
			EventTranslator(Des* inDes, Des* outDes = null, bool completeTranslation = true);
			EventTranslator(DesProject::DesIteratorPtr& desIterator, Des* outDes = null, bool completeTranslation = true);
			virtual ~EventTranslator(void);

		public:
			//adds another DES to the list of input DES to be translated
			void addInputDes(const Des* inDes);

			//sets the output DES that owns the translated events
			void setOutputDes(const Des* outDes);

			//when the given DES set is considered complete the caller can call
			//this method to compute the translation. This is can be done automatically
			//or later if at creation time the des set is not complete
			void computeTranslation();

			//Translates between an event from a source DES to an event in the output DES
			virtual const DesEvent* translate(const DesEvent* srcDesEvent, unsigned int srcDesId = 0) const;

			//Translates between an event from a source DES to an event in the output DES
			virtual bool translate(const DesEvent* srcDesEvent, const DesEvent*& o_outEvent) const;
			virtual bool translate(const DesEvent* srcDesEvent, unsigned int srcDesId, const DesEvent*& o_outEvent) const;

		protected:
			typedef std::map<std::wstring, const DesEvent*> EventNameMap;
			typedef EventNameMap::iterator EventNameIt;

			typedef std::vector< std::vector<DesEvent::ID> > EventDictionary;

		protected:
			//The dictionary that maps the (Des; DesEvent) pair to a DES event in the outpu DES of an algorithm like meet
			EventDictionary m_eventDict;

			//The set of DES from where the source events being mapped come from. The DES ID is the index of the DES
			//in this set. Note that the DES set is an address thus it simply an alias of a set hold by another object
			//most likely an algorithm
			std::vector<const Des*> m_inDesSet;

			const Des* m_outDes;

			//if true (by default) the algorithm does not allow unknown entries, input events that exist in the input DES
			//but on't exist in the output DES thus ensuring a complete translation. Some algorithms require more flexibility
			bool m_completeTransl;

	};
}
