/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QGroupBox>
#include <QTextEdit>
#include <qevent.h>

#include "CommonDefinitions.h"
#include "GedDesEditorOutputUiPart.h"


namespace DESpot
{


GedDesEditorOutputUiPart::GedDesEditorOutputUiPart(Ui::GedDesEditorUI* pUiContainer)
{
	if (pUiContainer == null)
		throw EX("Invalid (null) UI Container. Cannot create the DES editor output UI part")

	//setup widget references
	m_pGedDesEditorOutputGBox = pUiContainer->m_desEditorOutputGBox;
	m_pGedDesEditorOutputWidg = pUiContainer->m_outputWidg;

	//setup event filters
	m_pGedDesEditorOutputGBox->installEventFilter(this);

	//initialize widgets
}

//_________________________________________________________________________________________________

GedDesEditorOutputUiPart::~GedDesEditorOutputUiPart(void)
{
}

//_________________________________________________________________________________________________

bool GedDesEditorOutputUiPart::eventFilter(QObject* target, QEvent* event)
{	
	if (target == m_pGedDesEditorOutputGBox && event->type() == QEvent::Resize)
	{
		QResizeEvent* resizeEvent = dynamic_cast<QResizeEvent*>(event);
		m_pGedDesEditorOutputWidg->resize(resizeEvent->size() - QSize(0,28));
	}

	return QObject::eventFilter(target, event);

}

//_________________________________________________________________________________________________

void GedDesEditorOutputUiPart::clear()
{
	m_pGedDesEditorOutputWidg->clear();
}

//_________________________________________________________________________________________________

void GedDesEditorOutputUiPart::write(const QString& text)
{
	m_pGedDesEditorOutputWidg->insertHtml(text);
	m_pGedDesEditorOutputWidg->moveCursor(QTextCursor::End);
}

//_________________________________________________________________________________________________

void GedDesEditorOutputUiPart::writeLine(const QString& text)
{
	m_pGedDesEditorOutputWidg->insertHtml(text);
	m_pGedDesEditorOutputWidg->insertHtml("<br>");
	m_pGedDesEditorOutputWidg->moveCursor(QTextCursor::End);
}

} //end of namespace DESpot

