/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QDialog>

#include "CommonDefinitions.h"
#include "ui_DesEventEditorDialog.h"
#include "DesEvent.h"
#include "Des.h"

namespace DESpot
{

class DesEventEditorDlg : public QDialog, public Ui::DesEventEditorDlgUI
{
	//Construction
	public:
		DesEventEditorDlg(DesType desType, QWidget *parent = null);
		DesEventEditorDlg(DesType desType, const DesEvent& event, QWidget *parent = null);
		virtual ~DesEventEditorDlg(void);

	//Operations
	public:
		const DesEvent& resultEvent() const;

//add by bini
	public: bool event_isTemplate;
		bool isTemplate()
		{
			return event_isTemplate;
		}
		void setTemplate(bool is_Template)
		{
			event_isTemplate=is_Template;
		}

	//Overridables
	private:
		virtual void accept();
		virtual void reject();

	//Implementation Methods
	private:
		void updateUI();
		void setupEventTypeWidget(DesType desType);		

	public:
		DesEvent m_event;

	//Constants
	private:
		static const QString cDefaultTypeName;
		static const QString cRequestTypeName;
		static const QString cAnswerTypeName; 
		static const QString cLDataTypeName;
};

} //end of namespace DESpot
