/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ProjectWorkspace.h"
#include "ui_FlatProjectEditor.h"

class QResizeEvent;
class QButtonGroup;

namespace DESpot
{

class FlatProjectEditor;
class DesFlatProject;
class FlatProjStructureUiPart;
class FlatProjSummaryUiPart;


class FlatProjectWorkspace: public ProjectWorkspace, private Ui::FlatProjectEditorUI
{
	Q_OBJECT

	public:
		FlatProjectWorkspace(FlatProjectEditor* pFlatProjectEditor, DesFlatProject* pProject);
		virtual ~FlatProjectWorkspace(void);

	public:
		virtual ProgressWidget* progressWidget();

	//Overridables_________________________________________________
	protected:
		virtual bool eventFilter(QObject* target, QEvent* event);

	//Implementations Methods _____________________________________
	private:
		FlatProjectEditor* flatProjectEditor();
		
		void createUiParts(DesFlatProject* pProject);
		void setupEventFilters();
		//setup connections between widgets
		void setupConnections();
		
		//Added by Adam for BDDExport
		void createActions();
		void setupMenu();

		void positionSplitters();

	//UI Parts specific to flat projects (the rest are inherited from the ProjectWorkspace
	private:
		FlatProjStructureUiPart* m_pStructureUiPart;

	//Actions_____________________________________________________
	private:
		//Added by Adam for BDDExport
		QAction* m_exportToBDDsdAct;

		//Added by Adam for BDD Tools
                #ifdef __ENABLE_BDD__
		QAction* m_runBddCheckAllToolAct;
		QAction* m_runBddNonblockingToolAct;
		QAction* m_runBddControllabilityToolAct;
		QAction* m_runBddNBControllabilityToolAct;
		QAction* m_runBddTDESControllabilityToolAct;
		QAction* m_runBddSDControllabilityToolAct;
		QAction* m_runBddProperTimebehaviorToolAct;
		QAction* m_runBddSSingularProhibitableBehaviorToolAct;
		QAction* m_runBddPlantCompletenessToolAct;
		QAction* m_runBddALFToolAct;
                #endif

		//Added by David for Distributed Tools		
		QAction* m_runDistCheckAll;
};

} //end of namespace DESpot
