
/*	Author: Xu Han
	Supervisor: Dr. Ryan Leduc
	

	2010
*/
#pragma once

#include <map>
#include <deque>
#include <vector>
#include <string>
#include <iostream>
#include <QMessageBox>
#include <sstream>
#include "DesAlgo.h"
#include "DesState.h"
#include "DesEvent.h"
#include "DesProject.h"
#include "TireStorage.h"
#include "ProductTransitionMap.h"
#include "PendingStructure.h"

namespace DESpot
{
	class Des;

	class newSyncAlgo : virtual public DesAlgo
	{
       //--------------type  define-----------------------

	public:
		typedef std::vector<const Des*> DesSet;
		typedef DesSet::iterator DesSetIt;
		typedef DesSet::const_iterator DesSetCIt;
	    typedef std::vector<short> SrcStateTuple; 
	    typedef std::deque<SrcStateTuple*> SourceStateList;


         //-----------------data define------------------------------
	public:
		DesSet m_inDesSet;
		bool m_checkDesIntegrity;
	public:
		static const std::wstring cSyncAlgoDesc;
		static const std::wstring cSyncIntegError;
	public:
	    short DesNum;
        short EventNum;
        short StateMaxNum;
        short ***transitionMatrix;
	    SourceStateList m_pendingList;
	    AlgoTrie *turpleStorage;
        ProductTransitionMap *tranMap;
		PendingList *main_pendinglist;
		bool m_integrity;
		void setIntegrity(bool in_m_integrity);

     //--------------function define----------------------------
	public:
		newSyncAlgo(bool checkIntegrity = true);
		newSyncAlgo(const Des* des1, const Des* des2, bool checkIntegrity = true);
		newSyncAlgo(DesProject::DesIteratorPtr desIterator, bool checkIntegrity = true);
		virtual ~newSyncAlgo(void);
	public:
		void addInputDes(const Des* inDes);
		void addInputDes(DesProject::DesIteratorPtr desIterator);
	public:
		virtual bool runAlgo();
	public:
		virtual void prepareRun();
		virtual void onEventBlocked(short eventId,  SrcStateTuple& srcStateTuple, short iSrc);
	public:
		void loadProductDes();
		void createInitialStateTuple();		
	// Added by zain for counter example
		inline int getDesNum(){return DesNum;} 

	};
}   //End of namespace DESpot
