/*	Author:		Magdin Stoica
    Supervisor: Dr. Ryan Leduc

    Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering,
    Computing and Software Department,
    McMaster University
    2003 - 2007
*/

#pragma once

#include <QDialog>

#include "ui_AddInterfaceDlg.h"
#include "DesHierProject.h"

namespace DESpot
{
    class AddInterfaceDlg: public QDialog, private Ui::AddInterfaceDlgUI
    {
        public:
			 AddInterfaceDlg(const DesHierProject& project, QWidget* parent = null);
             AddInterfaceDlg(const DesHierProject& project,const std::wstring& intName, QWidget* parent = null);
            ~AddInterfaceDlg(void);

        public:
            std::wstring getSubsysName() const;

            std::wstring getInterfName() const;
            void setInterfName(const std::wstring& interfName);
            bool isNewInterface() const;

        private:
            void setupSubsysWidget();

        //Overridables
        protected:
            virtual void accept();
            virtual void reject();

        private:
            const DesHierProject& m_project;
            std::wstring m_subsysName;
            std::wstring m_interfName;
            bool m_newInterface;
    };

} //end of namespace DESpot
