/*	Author: Zain Ajaz
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2012 - 2013

*/
#pragma once
#include <deque>
#include <vector>
#include <iostream>
using namespace std;

namespace DESpot
{

class StateInfoNode
{ public:
  short Event;
  StateInfoNode * prev;
};

class StateInfoTree
{public:
	typedef std::deque<StateInfoNode*> LinkList;
	
private:
	LinkList list;
	long long nodecount;
	int Index;
	StateInfoNode* cur;
	int block_size;

public:
	StateInfoTree()
	{	
		block_size=100000;
		list.clear();
		StateInfoNode *cur=new StateInfoNode[block_size];
		list.push_back(cur);
	}

	StateInfoTree(int size)
	{   
		block_size=size;
		list.clear();
		cur=new StateInfoNode[block_size];
		list.push_back(cur);
	}
     
	~StateInfoTree()
	{while(list.empty()==false)
		{
			StateInfoNode *temp=list.front();
			delete [] temp; //his code had delete not delete []
			list.pop_front();
		}
	}

	StateInfoNode * AllocateNode(void)
	{	
		StateInfoNode * temp = cur;	
		Index++;
		if(Index==block_size)
			{
				Index=0;
				cur=new StateInfoNode[block_size];
				list.push_back(cur);				
			}
		else
		{
		cur++;
		}

		return temp;
	}
};

}

