/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QDialog>

#include "CommonDefinitions.h"
#include "ui_NewDesDialog.h"
#include "Des.h"

namespace DESpot
{

	class NewDesDialog  : public QDialog, public Ui::NewDesDialogUI
	{
		public:
			//Initializes the dialog with a parent: name and type will be initially shown with default values
			NewDesDialog(QWidget *parent = null);

			//Initializes the dialog to show the given name and type
			NewDesDialog(const std::wstring& desName, DesType desType = eRegularDes, QWidget *parent = null);

			~NewDesDialog(void);

		public:
			//Returns the name chosen by the user
			std::wstring getDesName() const;

			//Returns the type chosen by the user
			DesType getDesType() const;


		//Overridables
		private:
			virtual void accept();
			virtual void reject();

		private:
			//The name of the DES chosen by the user in the dialog
			QString m_desName;

			//The type of DES chosen by the user in the dialog
			DesType m_desType;

			
	};

} // end of namespace DESpot
