/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 *
 * Description: This module manages the distribution of the requested 
 * project checks. It separates the task by subsystem and task (or only
 * subsystem in the case of BDD check all) and utilizes CommHandler to
 * send the jobs to different slave nodes
 ************************************************************************/
#pragma once

#include "DistCommon.h"
#include "CommHandler.h"

#include "CommonDefinitions.h"
#include "FlatProjectPropCheck.h"
#include "HierProjectPropCheck.h"
#include "DesAlgo.h"
#include "DesInterface.h"

#ifdef __ENABLE_DIST__
#include <pthread.h>
#endif

namespace DESpot 
{
	// Used by HISC checks to determine which checks to perform across the various levels
	enum checkType { nonBlocking, controllable, iConsist, iValid, All };

	static string projectPath;

	static int freeSlots;

#ifdef __ENABLE_DIST__
	static pthread_mutex_t distHandlerMutex = PTHREAD_MUTEX_INITIALIZER;
	static pthread_cond_t distHandlerCond = PTHREAD_COND_INITIALIZER;
#endif

	class DistHandler
	{
		public:
			DistHandler(DesProject* project);
			~DistHandler();

		public:
			// Flat system check. Only valid to check both nonblocking and controllability (no sense in distributing if only one)
			resultStruct runFlatCheck(bool incremental);
			// HISC system check. Runs through each subsystem and performs the specified check type. Incremental check is not supported for 'All' checkType
			resultStruct runHISCCheck(checkType type, bool isBDD, bool incremental);
			// Synthesis on HISC system. Runs through each subsystem
			DesAlgo::ErrorList runSynth(char choice);

		private:
			DesProject& m_project;
	};
}
