/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QDialog>

#include "CommonDefinitions.h"
#include "ui_DesTransitionEditorDialog.h"
#include "Des.h"
#include "DesTransition.h"

namespace DESpot
{

class GedDesTransEditorDlg : public QDialog, public Ui::DesTransEditorDlgUI
{
	Q_OBJECT

	//Construction
	public:
		GedDesTransEditorDlg(const Des& des, QWidget *parent = null);
		GedDesTransEditorDlg(const DesTransition* pTrans, const Des& des, QWidget *parent = null);
		GedDesTransEditorDlg(const DesState *fromState, const DesState *toState, const Des& des, QWidget *parent);
		virtual ~GedDesTransEditorDlg(void);

	//Operations
	public:
		const DesTransition& resultTransition() const;

	private slots:
		void onSelfTransClicked(bool isChecked);
		void onTransFromStateChanged(const QString newFromState);

    //Overridables
	private:
		virtual void accept();
		virtual void reject();

	//Implementation Methods
	private:
		void updateUI();
		
		//the setup functions fill the controls with data and are called when the dialog is initialized
		void setupTransStateWidgets();
		void setupTransEventWidget();

		//the "accept" functions are called from the "accept" overridable to validate and accept
		//the different data entered in the dialog by the user
		bool acceptFromState();
		bool acceptEvent();
		bool acceptToState();

	private:
		const Des& m_des;
		DesTransition m_trans;
		bool m_transChanged;  //true if the user changed the transition in the dialog
};

} //end of namespace DESpot
