/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 *
 * Description: This module wraps the process by which slave nodes are spawned.
 * This is separate from the main communication wrapper in order to avoid a circular
 * dependency between CommHandler and HostList.
 ************************************************************************/
#pragma once

#include "CommonDefinitions.h"

#ifdef __ENABLE_DIST__
#include <mpi.h>
#endif

#include "Host.h"
#include "HostFileManager.h"

namespace DESpot
{
	class SpawnWrapper
	{
		public:
			// Spawn a slave process
			// Originally part of CommHandler, but created a circular dependency between
			// CommHandler and HostList
			static void spawnSlave(Host* target);
	};
}
