/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QObject>
#include <QMenu>

#include "ui_DesEditor.h"
#include "DesEvent.h"
#include "DesNotifications.h"
#include "CommonDefinitions.h"

class QGroupBox;
class QTreeWidget;

namespace DESpot
{
	class DesWorkspace;
	class DespotTreeWidget;
	class Des;
	class TransRecorder;

	class EventEditorUiPart: public QObject, private DesNotifications
	{
		Q_OBJECT	

		public:
			EventEditorUiPart(DesWorkspace* pWorkspace, Ui::DesEditorUI* pUiContainer, Des* pDes,
							  TransRecorder& transRecorder);
			virtual ~EventEditorUiPart(void);

		public:
			void clearSelection();

			//returns the context menu for this UI Part
			QMenu& getContextMenu();

			QMenu& getEventTypeContextSubMenu();

		//Signals_______________________________________
		signals:
			void onCurrentEventChanged(const DesEvent& selectedEvent);
		
		//Slots_________________________________________
		private slots:			
			void onUserChangedEventName(const DesEvent& changedEvent, const std::wstring& newName);
			void onUserChangedEventAlias(const DesEvent& changedEvent, const std::wstring& newAlias);
			void onUserChangedEventCtrl(const DesEvent& changedEvent, bool newCtrl);
			void onUserChangedEventType(const DesEvent& changedEvent, EventType newType);

		//Des Notification Handlers_______________________
		private:
			//Notifications received from the contained DES when the its events change
			virtual void onEventAdded(const DesEvent& addedEvent);
			virtual void onEventChanged(const DesEvent& changedEvent);
			virtual void onRemovingEvent(const DesEvent& event);

		//Implementation Methods________________________
		private:
			void initEventViewWidget();	
			void setupConnections(DesWorkspace* pWorkspace);
		
		private:    
			EventViewerWidget* m_pEventViewWidg;

			QMenu m_eventEditorContextMenu;
			QMenu* m_eventTypeSubContextMenu;

			//The Des that owns the event displayed in this UI part
			Des* m_pDes;
			unsigned int m_desListnerId;
	};

} //end of namespace DESpot
