/*	Author:		Adam Brousseau
	Supervisor: Dr. Ryan Leduc
*/

#include <QWidget>

class QPushButton;
class QToolButton;
class QTextBrowser;
class QLabel;
class QLineEdit;
class QTreeWidget;
class QTreeWidgetItem;
class QUrl;

namespace DESpot
{

class MainForm;

class HelpBrowser : public QWidget
{
	Q_OBJECT
public:
	HelpBrowser(const QString &path, const QString &page, QWidget *parent = 0);
	//virtual void ~HelpBrowser(void);
	static void start();

private slots:
	void setupIndexTree();
	void updateWindowTitle(const QUrl &);
	void onOpenAboutHelp();
	void setSource(QString &pageCurrent);
	void updatePage(QTreeWidgetItem *current);
	void enableFindButton(const QString &keyword);
	void onFindButtonClick();
	void onPrintButtonClick();
	void updateColumnSize();

private:
	void onPrintPage(bool &images);
	void onPrintAll(bool &images, bool &compact);
	void onPrint(QString &htmlContent, bool &images);
	QString adjustImageLinks(QString &html);
	QString chopPageLinks(QString &html);
	QStringList FindPages(QStringList curPages, QString keyword);
	QString AssembleResults(QStringList foundPages, QStringList keywordList);

	QTextBrowser *contentTextBrowser;
	QTreeWidget *indexTree;	
	QPushButton *homeButton;
	QPushButton *backButton;
	QPushButton *forwardButton;
	QPushButton *aboutButton;
	QPushButton *findButton;
	QToolButton *printButton;
	QLabel *findLabel;
	QLineEdit *findBox;
};

} //end of namespace DESpot
