/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QDialog>

#include "CommonDefinitions.h"
#include "ui_DesSelfTransEditorDialog.h"
#include "Des.h"
#include "DesEvent.h"

namespace DESpot
{
	class DesSelfTransEditorDlg: public QDialog, public Ui::DesSelfTransEditorDlgUI
	{
		Q_OBJECT

		public:
			DesSelfTransEditorDlg(const Des& des, QWidget *parent = null);
			virtual ~DesSelfTransEditorDlg(void);

		//Operations
		public:
			const std::vector<const DesEvent*>& selectedEvents() const;

		//Event handlers
		private slots:
			void onOnlyShowUnusedToggled(bool isChecked);

		//Overridables
		protected:
			virtual void accept();
			virtual void reject();
			virtual void resizeEvent(QResizeEvent* event);
			virtual bool eventFilter(QObject* target, QEvent* event);

		//Implementation Methods
		private:
			//the setup functions fill the controls with data and are called when the dialog is initialized
			void initEventViewWidg();
			void resizeEventViewWidgHeaders(int eventViewWidgWidth);
			void loadEvents(bool showOnlyUnused);
			
			QTreeWidgetItem* createUiItemFromEvent(const DesEvent& event);
			const DesEvent& getEventFromUiItem(QTreeWidgetItem& eventUiItem);

		//Data
		private:
			//The DES that contains the events
			const Des& m_des;

			//The list of events selected by the user
			std::vector<const DesEvent*> m_selEvents;

		//Constants
		private:
			static const short cEventViewColumnCount;
			static const short cEventNameColumnIdx;
			static const short cEventAliasColumnIdx;

	};
} //end of namespace DESpot
