/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QMainWindow>
#include "DespotForm.h"
#include "CommonDefinitions.h"
#include "MainForm.h"

namespace DESpot
{

DespotForm::DespotForm(MainForm* pMainForm) : 
			m_thisWnd(pMainForm), 			
                        m_owner(null),
                        m_formType(eMainForm)
{
	if (pMainForm == null)
		throw EX("Invalid argument. The main form cannot be NULL.")

	m_pMainForm = pMainForm;	
}

//_________________________________________________________________________________________________

DespotForm::DespotForm(MainForm* pMainForm, QMainWindow* thisWnd, DespotForm* ownerForm, FormType formType) : 
			m_thisWnd(thisWnd), 			
                        m_owner(ownerForm),
                        m_formType(formType)
{
	if (pMainForm == null)
		throw EX("Invalid argument. The main form cannot be NULL.")

	m_pMainForm = pMainForm;	
}

//_________________________________________________________________________________________________

DespotForm::~DespotForm(void)
{
	m_pMainForm = null;
}

//_________________________________________________________________________________________________

bool DespotForm::onCloseForm()
{
	return m_pMainForm->onCloseForm(this);
}

//_________________________________________________________________________________________________

DespotForm* DespotForm::owner()
{
	return m_owner;
}

//_________________________________________________________________________________________________

MainForm* DespotForm::mainForm()
{
	if (m_pMainForm == NULL)
		throw EX("Object has invalid state. Main form has not been set and is null")

	return m_pMainForm;
}

//_________________________________________________________________________________________________

DespotForm::FormType DespotForm::type()
{
	return m_formType;
}

//_________________________________________________________________________________________________

QString DespotForm::title()
{
	return m_thisWnd->windowTitle();
}

//_________________________________________________________________________________________________

bool DespotForm::openedFromFile()
{
	return (getDocFileName().isEmpty()== false);
}

//_________________________________________________________________________________________________

void DespotForm::open()
{
	if (m_thisWnd->isHidden())
	{
		m_pMainForm->onOpenForm(this);
	}

	//show the window
	m_thisWnd->show();
	m_thisWnd->activateWindow();
	m_thisWnd->raise();

}

//_________________________________________________________________________________________________

QMainWindow* DespotForm::window()
{
	return m_thisWnd;
}

} //end of namespace DESpot
